/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class LightRay {
    public final Vector2D tip;
    public final Vector2D tail;
    public final double indexOfRefraction;
    public final double wavelength;
    private final double powerFraction;
    private ArrayList<VoidFunction0> removalListeners = new ArrayList();
    private ArrayList<VoidFunction0> moveToFrontListeners = new ArrayList();
    private Color color;
    private double waveWidth;
    private double numWavelengthsPhaseOffset;
    private final Shape oppositeMedium;
    public final boolean extendBackwards;
    private boolean extend;
    private double time;
    private ArrayList<VoidFunction0> stepListeners = new ArrayList();

    public LightRay(Vector2D vector2D, Vector2D vector2D2, double d, double d2, double d3, Color color, double d4, double d5, Shape shape, boolean bl, boolean bl2) {
        this.oppositeMedium = shape;
        this.extendBackwards = bl2;
        this.color = color;
        this.waveWidth = d4;
        this.tip = vector2D2;
        this.tail = vector2D;
        this.indexOfRefraction = d;
        this.wavelength = d2;
        this.powerFraction = d3;
        this.numWavelengthsPhaseOffset = d5;
        this.extend = bl;
    }

    public void addRemovalListener(VoidFunction0 voidFunction0) {
        this.removalListeners.add(voidFunction0);
    }

    public void addMoveToFrontListener(VoidFunction0 voidFunction0) {
        this.moveToFrontListeners.add(voidFunction0);
    }

    public double getSpeed() {
        return 2.99792458E8 / this.indexOfRefraction;
    }

    public void remove() {
        for (VoidFunction0 voidFunction0 : this.removalListeners) {
            voidFunction0.apply();
        }
        this.removalListeners.clear();
    }

    public double getPowerFraction() {
        return this.powerFraction;
    }

    public boolean intersects(Shape shape) {
        return !new Area(shape){
            {
                this.intersect(new Area(new BasicStroke(1.0E-10f).createStrokedShape(LightRay.this.toLine2D())));
            }
        }.isEmpty();
    }

    public Line2D toLine2D() {
        return new Line2D.Double(this.tail.toPoint2D(), this.tip.toPoint2D());
    }

    public double getLength() {
        return this.tip.minus(this.tail).magnitude();
    }

    public Vector2D toVector2D() {
        return new Vector2D(this.tail.toPoint2D(), this.tip.toPoint2D());
    }

    public Color getColor() {
        return this.color;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public void moveToFront() {
        for (VoidFunction0 voidFunction0 : this.moveToFrontListeners) {
            voidFunction0.apply();
        }
    }

    public String toString() {
        return "tail = " + this.tail + ", tip = " + this.tip;
    }

    public double getExtensionFactor() {
        if (this.extendBackwards || this.extend) {
            return this.wavelength * 1000000.0;
        }
        return 0.0;
    }

    public Shape getWaveShape() {
        BasicStroke basicStroke = new BasicStroke((float)this.waveWidth, 0, 0);
        Shape shape = basicStroke.createStrokedShape(this.extendBackwards ? this.getExtendedLineBackwards() : this.getExtendedLine());
        Area area = new Area(shape){
            {
                if (LightRay.this.oppositeMedium != null) {
                    this.subtract(new Area(LightRay.this.oppositeMedium));
                }
            }
        };
        return area;
    }

    private Line2D.Double getExtendedLine() {
        return new Line2D.Double(this.tail.toPoint2D(), this.tip.plus(this.getUnitVector().times(this.getExtensionFactor())).toPoint2D());
    }

    private Line2D.Double getExtendedLineBackwards() {
        return new Line2D.Double(this.tail.plus(this.getUnitVector().times(-this.getExtensionFactor())).toPoint2D(), this.tip.toPoint2D());
    }

    public Vector2D getUnitVector() {
        return new Vector2D(this.tail.toPoint2D(), this.tip.toPoint2D()).normalized();
    }

    public void addStepListener(VoidFunction0 voidFunction0) {
        this.stepListeners.add(voidFunction0);
    }

    public void setTime(double d) {
        this.time = d;
        for (VoidFunction0 voidFunction0 : this.stepListeners) {
            voidFunction0.apply();
        }
    }

    public double getWaveWidth() {
        return this.waveWidth;
    }

    public double getNumberOfWavelengths() {
        return this.getLength() / this.wavelength;
    }

    public double getNumWavelengthsPhaseOffset() {
        return this.numWavelengthsPhaseOffset;
    }

    public Shape getOppositeMedium() {
        return this.oppositeMedium;
    }

    public boolean contains(Vector2D vector2D, boolean bl) {
        if (bl) {
            return this.getWaveShape().contains(vector2D.getX(), vector2D.getY());
        }
        return new BasicStroke((float)this.getRayWidth()).createStrokedShape(this.toLine2D()).contains(vector2D.toPoint2D());
    }

    public double getRayWidth() {
        return 1.5992063492063494E-7;
    }

    public Vector2D getVelocityVector() {
        return this.tip.minus(this.tail).normalized().times(this.getSpeed());
    }

    public double getFrequency() {
        return this.getSpeed() / this.getWavelength();
    }

    public double getAngularFrequency() {
        return this.getFrequency() * Math.PI * 2.0;
    }

    public double getPhaseOffset() {
        return this.getAngularFrequency() * this.time - Math.PI * 2 * this.numWavelengthsPhaseOffset;
    }

    public double getCosArg(double d) {
        double d2 = this.getAngularFrequency();
        double d3 = Math.PI * 2 / this.getWavelength();
        double d4 = d;
        double d5 = this.time;
        return d3 * d4 - d2 * d5 - Math.PI * 2 * this.numWavelengthsPhaseOffset;
    }
}

