/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.bendinglight.view.LaserColor;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.geom.Dimension2D;

public class Laser {
    public final Property<Vector2D> emissionPoint;
    public final Property<Vector2D> pivot = new Property<Vector2D>(new Vector2D(0.0, 0.0));
    public final Property<Boolean> on = new Property<Boolean>(false);
    public final Property<LaserColor> color = new Property<LaserColor.OneColor>(new LaserColor.OneColor(6.5E-7));
    public final Property<Boolean> wave = new Property<Boolean>(false);

    public Laser(double d, double d2, final boolean bl) {
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                if (Laser.this.wave.get().booleanValue() && Laser.this.getAngle() > 3.0194 && bl) {
                    Laser.this.setAngle(3.0194);
                }
            }
        };
        this.wave.addObserver(simpleObserver);
        this.emissionPoint = new Property<Vector2D>(Vector2D.createPolar(d, d2));
        this.emissionPoint.addObserver(simpleObserver);
    }

    public void resetLocation() {
        this.emissionPoint.reset();
        this.pivot.reset();
    }

    public void translate(Dimension2D dimension2D) {
        this.translate(dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void translate(double d, double d2) {
        this.emissionPoint.set(this.emissionPoint.get().plus(d, d2));
        this.pivot.set(this.pivot.get().plus(d, d2));
    }

    public Vector2D getDirectionUnitVector() {
        return this.pivot.get().minus(this.emissionPoint.get()).normalized();
    }

    public void setAngle(double d) {
        double d2 = this.pivot.get().distance(this.emissionPoint.get());
        this.emissionPoint.set(Vector2D.createPolar(d2, d).plus(this.pivot.get()));
    }

    public double getAngle() {
        return this.getDirectionUnitVector().getAngle() + Math.PI;
    }

    public double getDistanceFromPivot() {
        return this.emissionPoint.get().minus(this.pivot.get()).magnitude();
    }

    public double getWavelength() {
        return this.color.get().getWavelength();
    }

    public double getFrequency() {
        return 2.99792458E8 / this.getWavelength();
    }
}

