/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.common.phetcommon.math.vector.Vector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import java.util.ArrayList;

public class IntensityMeter {
    public final Property<Vector2D> sensorPosition;
    public final Property<Vector2D> bodyPosition;
    public final Property<Boolean> enabled = new Property<Boolean>(false);
    public final Property<Reading> reading = new Property<Reading>(Reading.MISS);
    private final ArrayList<Reading> rayReadings = new ArrayList();

    public IntensityMeter(double d, double d2, double d3, double d4) {
        this.sensorPosition = new Property<Vector2D>(new Vector2D(d, d2));
        this.bodyPosition = new Property<Vector2D>(new Vector2D(d3, d4));
    }

    public void translateSensor(Dimension2D dimension2D) {
        this.sensorPosition.set(this.sensorPosition.get().plus(dimension2D));
    }

    public void translateBody(Dimension2D dimension2D) {
        this.bodyPosition.set(this.bodyPosition.get().plus(dimension2D));
    }

    public Ellipse2D.Double getSensorShape() {
        double d = 1.215E-6;
        return new Ellipse2D.Double(this.sensorPosition.get().getX() - d, this.sensorPosition.get().getY() - d, d * 2.0, d * 2.0);
    }

    public void clearRayReadings() {
        this.rayReadings.clear();
        this.reading.set(Reading.MISS);
    }

    public void addRayReading(Reading reading) {
        this.rayReadings.add(reading);
        this.updateReading();
    }

    private void updateReading() {
        ArrayList<Reading> arrayList = new ArrayList<Reading>();
        for (Reading reading : this.rayReadings) {
            if (!reading.isHit()) continue;
            arrayList.add(reading);
        }
        if (arrayList.size() == 0) {
            this.reading.set(Reading.MISS);
        } else {
            double d = 0.0;
            for (Reading reading : arrayList) {
                d += reading.getValue();
            }
            this.reading.set(new Reading(d));
        }
    }

    public void translateAll(Dimension2D dimension2D) {
        this.translateBody(dimension2D);
        this.translateSensor(dimension2D);
    }

    public static class Reading {
        private double value;
        public static final Reading MISS = new Reading(){

            public String getString() {
                return BendingLightStrings.MISS;
            }

            public boolean isHit() {
                return false;
            }
        };

        protected Reading() {
        }

        public Reading(double d) {
            this.value = d;
        }

        public String getString() {
            return Reading.format(this.value);
        }

        public static String format(double d) {
            return new DecimalFormat("0.00").format(d * 100.0) + "%";
        }

        public boolean isHit() {
            return true;
        }

        public double getValue() {
            return this.value;
        }
    }
}

