/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;

public class DispersionFunction {
    private double referenceIndexOfRefraction;
    private double referenceWavelength;

    public double getSellmeierValue(double d) {
        double d2 = d * d;
        double d3 = 1.03961212;
        double d4 = 0.231792344;
        double d5 = 1.01046945;
        double d6 = 6.00069867E-15;
        double d7 = 2.00179144E-14;
        double d8 = 1.03560653E-10;
        return Math.sqrt(1.0 + d3 * d2 / (d2 - d6) + d4 * d2 / (d2 - d7) + d5 * d2 / (d2 - d8));
    }

    public DispersionFunction(double d) {
        this(d, 6.5E-7);
    }

    public DispersionFunction(double d, double d2) {
        this.referenceIndexOfRefraction = d;
        this.referenceWavelength = d2;
    }

    public double getIndexOfRefractionForRed() {
        return this.getIndexOfRefraction(6.5E-7);
    }

    public double getIndexOfRefraction(double d) {
        double d2 = this.getAirIndex(this.referenceWavelength);
        double d3 = this.getSellmeierValue(this.referenceWavelength);
        double d4 = d3 - d2;
        double d5 = (this.referenceIndexOfRefraction - d2) / d4;
        d5 = MathUtil.clamp(0.0, d5, Double.POSITIVE_INFINITY);
        double d6 = d5 * this.getSellmeierValue(d) + (1.0 - d5) * this.getAirIndex(d);
        return d6;
    }

    private double getAirIndex(double d) {
        return 1.0 + 0.05792105 / (238.0185 - Math.pow(d * 1000000.0, -2.0)) + 0.00167917 / (57.362 - Math.pow(d * 1000000.0, -2.0));
    }
}

