/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.bendinglight.model;

import edu.colorado.phet.bendinglight.BendingLightStrings;
import edu.colorado.phet.bendinglight.model.IntensityMeter;
import edu.colorado.phet.bendinglight.model.Laser;
import edu.colorado.phet.bendinglight.model.LightRay;
import edu.colorado.phet.bendinglight.model.MediumState;
import edu.colorado.phet.bendinglight.view.LaserColor;
import edu.colorado.phet.bendinglight.view.LaserView;
import edu.colorado.phet.common.phetcommon.math.ModelBounds;
import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BendingLightModel
implements ResetModel {
    public static final MediumState AIR = new MediumState(BendingLightStrings.AIR, 1.000293);
    public static final MediumState WATER = new MediumState(BendingLightStrings.WATER, 1.333);
    public static final MediumState GLASS = new MediumState(BendingLightStrings.GLASS, 1.5);
    public static final MediumState DIAMOND = new MediumState(BendingLightStrings.DIAMOND, 2.419);
    public static final MediumState MYSTERY_A = new MediumState(BendingLightStrings.MYSTERY_A, 2.419, true);
    public static final MediumState MYSTERY_B = new MediumState(BendingLightStrings.MYSTERY_B, 1.4, true);
    private ConstantDtClock clock;
    protected final List<LightRay> rays = new LinkedList<LightRay>();
    public final Property<LaserView> laserView = new Property<LaserView>(LaserView.RAY);
    final double modelWidth = 4.0300000000000004E-5;
    final double modelHeight = 2.821E-5;
    protected final Laser laser;
    public final Property<Double> wavelengthProperty;
    protected final IntensityMeter intensityMeter = new IntensityMeter(1.2090000000000001E-5, -8.463E-6, 1.612E-5, -8.463E-6);
    public final ModelBounds visibleModelBounds = new ModelBounds();
    private final ArrayList<VoidFunction1<LightRay>> rayAddedListeners = new ArrayList();
    private final ArrayList<VoidFunction0> modelUpdateListeners = new ArrayList();
    private final ArrayList<VoidFunction0> resetListeners = new ArrayList();

    public BendingLightModel(final ConstantDtClock constantDtClock, double d, boolean bl, double d2) {
        this.laser = new Laser(d2, d, bl);
        this.clock = constantDtClock;
        constantDtClock.addClockListener(new ClockAdapter(){

            public void simulationTimeChanged(ClockEvent clockEvent) {
                for (LightRay lightRay : BendingLightModel.this.rays) {
                    lightRay.setTime(constantDtClock.getSimulationTime());
                }
            }
        });
        new RichSimpleObserver(){

            public void update() {
                BendingLightModel.this.updateModel();
            }
        }.observe(this.laser.on, this.laser.pivot, this.laser.emissionPoint, this.intensityMeter.sensorPosition, this.intensityMeter.enabled, this.laser.color, this.laserView);
        this.wavelengthProperty = new Property<Double>(Double.valueOf(6.5E-7)){
            {
                this.addObserver(new VoidFunction1<Double>(){

                    @Override
                    public void apply(Double d) {
                        BendingLightModel.this.laser.color.set(new LaserColor.OneColor(d));
                    }
                });
            }
        };
        this.laserView.addObserver(new SimpleObserver(){

            public void update() {
                BendingLightModel.this.updateModel();
                BendingLightModel.this.getLaser().wave.set(BendingLightModel.this.laserView.get() == LaserView.WAVE);
            }
        });
    }

    protected void addRay(LightRay lightRay) {
        this.rays.add(lightRay);
        for (VoidFunction1<LightRay> voidFunction1 : this.rayAddedListeners) {
            voidFunction1.apply(lightRay);
        }
    }

    public double getWidth() {
        return 4.0300000000000004E-5;
    }

    public double getHeight() {
        return 2.821E-5;
    }

    public void addRayAddedListener(VoidFunction1<LightRay> voidFunction1) {
        this.rayAddedListeners.add(voidFunction1);
    }

    public Laser getLaser() {
        return this.laser;
    }

    public ConstantDtClock getClock() {
        return this.clock;
    }

    public Iterable<? extends LightRay> getRays() {
        return this.rays;
    }

    public IntensityMeter getIntensityMeter() {
        return this.intensityMeter;
    }

    protected void clearModel() {
        for (LightRay lightRay : this.rays) {
            lightRay.remove();
        }
        this.rays.clear();
        this.intensityMeter.clearRayReadings();
    }

    public void updateModel() {
        this.clearModel();
        this.propagateRays();
        for (VoidFunction0 voidFunction0 : this.modelUpdateListeners) {
            voidFunction0.apply();
        }
    }

    protected abstract void propagateRays();

    public static double getTransmittedPower(double d, double d2, double d3, double d4) {
        return 4.0 * d * d2 * d3 * d4 / Math.pow(d * d3 + d2 * d4, 2.0);
    }

    public static double getReflectedPower(double d, double d2, double d3, double d4) {
        return Math.pow((d * d3 - d2 * d4) / (d * d3 + d2 * d4), 2.0);
    }

    public void addModelUpdateListener(VoidFunction0 voidFunction0) {
        this.modelUpdateListeners.add(voidFunction0);
    }

    @Override
    public void addResetListener(VoidFunction0 voidFunction0) {
        this.resetListeners.add(voidFunction0);
    }
}

