/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.faucet;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponents;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.faucet.FaucetSliderNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaucetNode
extends PNode {
    private static final BufferedImage FAUCET_IMAGE = PiccoloPhetApplication.RESOURCES.getImage("faucet_front.png");
    private static final BufferedImage PIPE_IMAGE = PiccoloPhetApplication.RESOURCES.getImage("faucet_pipe.png");
    private static final Point2D HANDLE_CENTER = new Point2D.Double(46.0, 8.0);
    public static final Dimension2D HANDLE_SIZE = new Dimension2DDouble(85.0, 16.0);
    private final PImage faucetNode;
    private final FaucetSliderNode sliderNode;

    public FaucetNode(IUserComponent iUserComponent, double d, Property<Double> property, ObservableProperty<Boolean> observableProperty, double d2, boolean bl) {
        this.setScale(1.2);
        this.faucetNode = new PImage(FAUCET_IMAGE);
        this.addChild(this.faucetNode);
        Rectangle2D.Double double_ = new Rectangle2D.Double(-d2, 32.0, d2 + 0.5, 46.0);
        PhetPPath phetPPath = new PhetPPath((Shape)double_, new TexturePaint(PIPE_IMAGE, new Rectangle2D.Double(0.0, ((RectangularShape)double_).getY(), PIPE_IMAGE.getWidth(), PIPE_IMAGE.getHeight())));
        this.addChild(phetPPath);
        this.sliderNode = new FaucetSliderNode(UserComponentChain.chain(iUserComponent, UserComponents.slider), observableProperty, d, property, bl){
            {
                this.setOffset(4.0, 2.5);
                this.scale(HANDLE_SIZE.getWidth() / this.getFullBounds().getWidth());
            }
        };
        this.addChild(this.sliderNode);
        this.faucetNode.addInputEventListener(new NonInteractiveEventHandler(UserComponents.faucetImage));
        phetPPath.addInputEventListener(new NonInteractiveEventHandler(UserComponents.faucetImage));
    }

    public Point2D getGlobalOutputCenter() {
        return this.faucetNode.localToGlobal(new Point2D.Double(83.0, 133.0));
    }

    public Dimension2D getGlobalOutputSize() {
        return this.faucetNode.localToGlobal(new Dimension2DDouble(52.0, 0.0));
    }
}

