/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterValue;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterValues;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.SpectrumImageFactory;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.nodes.PComposite;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class WavelengthControl
extends PhetPNode {
    private static final Dimension THUMB_SIZE = new Dimension(20, 20);
    private static final Stroke THUMB_STROKE = new BasicStroke(1.0f);
    private static final Color THUMB_STROKE_COLOR = Color.WHITE;
    private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("0");
    private static final String UNITS_LABEL = PhetCommonResources.getString("Common.wavelengthControl.nm");
    private static final Stroke CURSOR_STROKE = new BasicStroke(1.0f);
    private static final Color CURSOR_COLOR = Color.BLACK;
    private static final String UV_STRING = PhetCommonResources.getString("Common.wavelengthControl.UV");
    private static final String IR_STRING = PhetCommonResources.getString("Common.wavelengthControl.IR");
    private static final Color UV_TRACK_COLOR = Color.LIGHT_GRAY;
    private static final Color UV_LABEL_COLOR = Color.BLACK;
    private static final Color IR_TRACK_COLOR = UV_TRACK_COLOR;
    private static final Color IR_LABEL_COLOR = UV_LABEL_COLOR;
    private final double minWavelength;
    private final double maxWavelength;
    private final Color uvColor;
    private final Color irColor;
    private final Thumb thumb;
    private final Track track;
    private final PPath trackBorder;
    private final ValueDisplay valueDisplay;
    private final Cursor cursor;
    private final EventListenerList listenerList;
    private double wavelength;
    private final IUserComponent userComponent;

    public WavelengthControl(IUserComponent iUserComponent, boolean bl, int n, int n2) {
        this(iUserComponent, bl, n, n2, 380.0, 780.0, UV_TRACK_COLOR, UV_LABEL_COLOR, IR_TRACK_COLOR, IR_LABEL_COLOR);
    }

    public WavelengthControl(IUserComponent iUserComponent, boolean bl, int n, int n2, double d, double d2, Color color, Color color2, Color color3, Color color4) {
        if (d >= d2) {
            throw new IllegalArgumentException("have you reversed the minWavelength and maxWavelength args?");
        }
        this.userComponent = iUserComponent;
        this.minWavelength = d;
        this.maxWavelength = d2;
        this.wavelength = this.minWavelength;
        this.uvColor = color;
        this.irColor = color3;
        this.listenerList = new EventListenerList();
        this.thumb = new Thumb(WavelengthControl.THUMB_SIZE.width, WavelengthControl.THUMB_SIZE.height);
        this.track = new Track(n, n2, d, d2, color, color2, color3, color4);
        this.valueDisplay = new ValueDisplay();
        this.cursor = new Cursor(3.0, this.track.getFullBounds().getHeight());
        this.trackBorder = new PPath();
        this.trackBorder.setPathTo(new Rectangle2D.Double(0.0, 0.0, this.track.getFullBounds().getWidth(), this.track.getFullBounds().getHeight()));
        this.trackBorder.setStroke(new BasicStroke(1.0f));
        this.trackBorder.setStrokePaint(Color.BLACK);
        this.addChild(this.track);
        this.addChild(this.trackBorder);
        this.addChild(this.valueDisplay);
        this.addChild(this.cursor);
        this.addChild(this.thumb);
        this.track.setOffset(0.0, 0.0);
        this.track.addInputEventListener(new CursorHandler());
        this.track.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                WavelengthControl.this.handleTrackClick(pInputEvent.getPositionRelativeTo(WavelengthControl.this.track));
            }
        });
        this.thumb.addInputEventListener(new CursorHandler());
        this.thumb.addInputEventListener(new SliderThumbDragHandler(this.userComponent, bl, SliderThumbDragHandler.Orientation.HORIZONTAL, this, this.track, this.thumb, new DoubleRange(d, d2), new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                WavelengthControl.this.setWavelength(d);
            }
        }){

            protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                return ParameterSet.parameterSet((IParameterKey)ParameterKeys.wavelength, WavelengthControl.this.getWavelength()).with(super.getParametersForAllEvents(pInputEvent));
            }
        });
        this.valueDisplay.addInputEventListener(new CursorHandler());
        this.updateUI();
        double d3 = this.wavelength;
        this.setWavelength(d);
        double d4 = this.getFullBoundsReference().getMinX();
        this.setWavelength(d2);
        double d5 = this.getFullBoundsReference().getMaxX();
        this.setWavelength(d3);
        PPath pPath = new PPath(new Line2D.Double(d4, 0.0, d5, 0.0)){
            {
                this.setPickable(false);
                this.setStrokePaint(new Color(0, 0, 0, 0));
            }
        };
        this.addChild(pPath);
        pPath.moveToBack();
    }

    public void setWavelength(double d) {
        if (d < this.minWavelength || d > this.maxWavelength) {
            throw new IllegalArgumentException("wavelength out of range: " + d);
        }
        if (d != this.wavelength) {
            this.wavelength = d;
            this.updateUI();
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public Color getWavelengthColor(double d) {
        Color color = d < 380.0 ? this.uvColor : (d > 780.0 ? this.irColor : VisibleColor.wavelengthToColor(d));
        return color;
    }

    public Color getWavelengthColor() {
        return this.getWavelengthColor(this.wavelength);
    }

    private void handleTrackClick(Point2D point2D) {
        double d = this.maxWavelength - this.minWavelength;
        double d2 = this.track.getFullBounds().getWidth();
        double d3 = this.minWavelength + point2D.getX() / d2 * d;
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.slider, UserActions.trackClicked, ParameterSet.parameterSet((IParameterKey)ParameterKeys.value, d3));
        this.setWavelength(d3);
    }

    private void commitTextField(IParameterValue iParameterValue) {
        String string = this.valueDisplay.getText();
        try {
            double d = Double.valueOf(string);
            if (d >= this.minWavelength && d <= this.maxWavelength) {
                if (d != this.wavelength) {
                    this.sendCommittedMessage(iParameterValue, d);
                    this.setWavelength(d);
                }
            } else {
                this.revertTextField(iParameterValue, ParameterValues.rangeError, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.revertTextField(iParameterValue, ParameterValues.numberFormatException, string);
        }
    }

    private void revertTextField(IParameterValue iParameterValue, IParameterValue iParameterValue2, String string) {
        this.sendCorrectedMessage(iParameterValue, iParameterValue2, string, this.wavelength);
        this.badInput();
        this.valueDisplay.setValue(this.wavelength);
    }

    private void updateUI() {
        double d = this.maxWavelength - this.minWavelength;
        PBounds pBounds = this.track.getFullBounds();
        double d2 = this.valueDisplay.getFullBounds().getWidth();
        double d3 = this.valueDisplay.getFullBounds().getHeight();
        Color color = this.getWavelengthColor();
        this.thumb.setPaint(color);
        double d4 = pBounds.getX();
        double d5 = pBounds.getWidth();
        double d6 = d4 + d5 * ((this.wavelength - this.minWavelength) / d);
        double d7 = pBounds.getHeight();
        this.thumb.setOffset(d6, d7);
        this.valueDisplay.setValue(this.wavelength);
        double d8 = d6 - d2 / 2.0;
        double d9 = -(d3 + 2.0);
        this.valueDisplay.setOffset(d8, d9);
        this.cursor.setOffset(d6, 0.0);
    }

    private void badInput() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    protected void sendCommittedMessage(IParameterValue iParameterValue, double d) {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.textField, UserActions.textFieldCommitted, ParameterSet.parameterSet((IParameterKey)ParameterKeys.commitAction, iParameterValue).with((IParameterKey)ParameterKeys.value, d));
    }

    protected void sendCorrectedMessage(IParameterValue iParameterValue, IParameterValue iParameterValue2, String string, double d) {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.textField, UserActions.textFieldCorrected, ParameterSet.parameterSet((IParameterKey)ParameterKeys.errorType, iParameterValue2).with((IParameterKey)ParameterKeys.commitAction, iParameterValue).with((IParameterKey)ParameterKeys.value, string).with((IParameterKey)ParameterKeys.correctedValue, d));
    }

    static /* synthetic */ String access$600() {
        return UNITS_LABEL;
    }

    private static class Cursor
    extends PPath {
        public Cursor(double d, double d2) {
            this.setPathTo(new Rectangle2D.Double(-d / 2.0, 0.0, d, d2));
            this.setStroke(CURSOR_STROKE);
            this.setStrokePaint(CURSOR_COLOR);
        }
    }

    private static class Thumb
    extends PPath {
        public Thumb(float f, float f2) {
            this.setStroke(THUMB_STROKE);
            this.setPaint(THUMB_STROKE_COLOR);
            this.setSize(f, f2);
        }

        public void setSize(float f, float f2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.5f * f, 0.3f * f2);
            generalPath.lineTo(0.5f * f, 1.0f * f2);
            generalPath.lineTo(-0.5f * f, 1.0f * f2);
            generalPath.lineTo(-0.5f * f, 0.3f * f2);
            generalPath.closePath();
            this.setPathTo(generalPath);
        }
    }

    private static class Track
    extends PComposite {
        public Track(int n, int n2, double d, double d2, Color color, Color color2, Color color3, Color color4) {
            PText pText;
            double d3 = d2 - d;
            double d4 = 380.0 - d;
            double d5 = d2 - 780.0;
            double d6 = d4 / d3 * (double)n;
            double d7 = d5 / d3 * (double)n;
            Image image = new SpectrumImageFactory.LinearSpectrumImageFactory().createHorizontalSpectrum(n, n2, d, d2, color, color3);
            PImage pImage = new PImage(image);
            pImage.setOffset(0.0, 0.0);
            this.addChild(pImage);
            if (d6 > 0.0) {
                pText = new PText(UV_STRING);
                pText.setTextPaint(color2);
                pText.scale((double)n2 * 0.7 / pText.getFullBounds().getHeight());
                if (d6 > pText.getFullBounds().getWidth()) {
                    this.addChild(pText);
                    pText.setOffset((d6 - pText.getFullBounds().getWidth()) / 2.0, ((double)n2 - pText.getFullBounds().getHeight()) / 2.0);
                }
            }
            if (d7 > 0.0) {
                pText = new PText(IR_STRING);
                pText.setTextPaint(color4);
                pText.scale((double)n2 * 0.7 / pText.getFullBounds().getHeight());
                if (d7 > pText.getFullBounds().getWidth()) {
                    this.addChild(pText);
                    pText.setOffset((double)n - d7 + (d7 - pText.getFullBounds().getWidth()) / 2.0, ((double)n2 - pText.getFullBounds().getHeight()) / 2.0);
                }
            }
        }
    }

    private class ValueDisplay
    extends PNode {
        public final JFormattedTextField formattedTextField;
        public final JLabel unitsLabel = new JLabel(WavelengthControl.access$600());
        private final PSwing pswing;

        public ValueDisplay() {
            this.formattedTextField = new JFormattedTextField();
            this.formattedTextField.setColumns(3);
            this.formattedTextField.setHorizontalAlignment(4);
            this.formattedTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WavelengthControl.this.commitTextField(ParameterValues.enterKey);
                }
            });
            this.formattedTextField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ValueDisplay.this.formattedTextField.selectAll();
                }

                public void focusLost(FocusEvent focusEvent) {
                    WavelengthControl.this.commitTextField(ParameterValues.focusLost);
                }
            });
            this.formattedTextField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 38) {
                        double d = WavelengthControl.this.wavelength + 1.0;
                        if (d <= WavelengthControl.this.maxWavelength) {
                            WavelengthControl.this.sendCommittedMessage(ParameterValues.upKey, d);
                            WavelengthControl.this.setWavelength(d);
                        } else {
                            WavelengthControl.this.sendCorrectedMessage(ParameterValues.upKey, ParameterValues.rangeError, String.valueOf(d), WavelengthControl.this.wavelength);
                            WavelengthControl.this.badInput();
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        double d = WavelengthControl.this.wavelength - 1.0;
                        if (d >= WavelengthControl.this.minWavelength) {
                            WavelengthControl.this.sendCommittedMessage(ParameterValues.downKey, d);
                            WavelengthControl.this.setWavelength(d);
                        } else {
                            WavelengthControl.this.sendCorrectedMessage(ParameterValues.downKey, ParameterValues.rangeError, String.valueOf(d), WavelengthControl.this.wavelength);
                            WavelengthControl.this.badInput();
                        }
                    }
                }
            });
            JPanel jPanel = new JPanel();
            EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout(jPanel);
            easyGridBagLayout.setInsets(new Insets(0, 0, 0, 0));
            jPanel.setLayout(easyGridBagLayout);
            easyGridBagLayout.setAnchor(17);
            int n = 0;
            int n2 = 0;
            easyGridBagLayout.addComponent(this.formattedTextField, n, n2++);
            easyGridBagLayout.addComponent(this.unitsLabel, n, n2);
            jPanel.setOpaque(false);
            this.unitsLabel.setOpaque(false);
            this.pswing = new PSwing(jPanel);
            this.addChild(this.pswing);
        }

        public void setValue(double d) {
            String string = VALUE_FORMAT.format(d);
            this.formattedTextField.setText(string);
        }

        public String getText() {
            return this.formattedTextField.getText().toLowerCase();
        }
    }
}

