/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.PhetUtilities;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.ButtonEventHandler;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ToolTipNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;

public class ButtonNode
extends PhetPNode {
    private final PNode parentNode;
    private final ArrayList<ActionListener> actionListeners;
    private Color foreground;
    private Color background;
    private Color shadowColor;
    private Color strokeColor;
    private Color disabledForeground;
    private Color disabledBackground;
    private Color disabledShadowColor;
    private Color disabledStrokeColor;
    private boolean enabled;
    private Insets margin;
    private int cornerRadius;
    private int shadowOffset;
    private String toolTipText;
    private PPath backgroundNode;
    private boolean focus;
    private boolean armed;
    private Paint mouseNotOverGradient;
    private Paint mouseOverGradient;
    private Paint armedGradient;
    private PNode contentNode;
    private PNode disabledContentNode;
    private final String actionCommand;
    private IUserComponent userComponent = new UserComponent(ButtonNode.class);
    private Function0<ParameterSet> parameters = new Function0<ParameterSet>(){

        @Override
        public ParameterSet apply() {
            return new ParameterSet();
        }
    };

    public ButtonNode(String string, PNode pNode, PNode pNode2) {
        this.contentNode = pNode;
        this.disabledContentNode = pNode2;
        this.actionCommand = string == null ? "" : string;
        this.disabledShadowColor = new Color(0, 0, 0, 0);
        this.disabledStrokeColor = new Color(190, 190, 190);
        this.strokeColor = Color.BLACK;
        this.enabled = true;
        this.cornerRadius = 8;
        this.parentNode = new PNode();
        this.shadowOffset = 3;
        this.disabledForeground = new Color(180, 180, 180);
        this.background = Color.GRAY;
        this.margin = new Insets(3, 10, 3, 10);
        this.disabledBackground = new Color(210, 210, 210);
        this.actionListeners = new ArrayList();
        this.toolTipText = null;
        this.foreground = Color.BLACK;
        this.shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.2f);
        this.addChild(this.parentNode);
    }

    protected final void update() {
        this.parentNode.removeAllChildren();
        PNode pNode = this.isEnabled() ? this.contentNode : this.disabledContentNode;
        double d = pNode.getFullBoundsReference().getWidth() + (double)this.margin.left + (double)this.margin.right;
        double d2 = pNode.getFullBoundsReference().getHeight() + (double)this.margin.top + (double)this.margin.bottom;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, d, d2, this.cornerRadius, this.cornerRadius);
        this.mouseNotOverGradient = this.createMouseNotOverGradient(d, d2);
        this.mouseOverGradient = this.createMouseOverGradient(d, d2);
        this.armedGradient = this.createArmedGradient(d, d2);
        this.backgroundNode = new PPath(double_);
        this.backgroundNode.addInputEventListener(new CursorHandler());
        if (this.enabled) {
            this.backgroundNode.setPaint(this.mouseNotOverGradient);
            this.backgroundNode.setStrokePaint(this.strokeColor);
        } else {
            this.backgroundNode.setPaint(this.createDisabledGradient(d, d2));
            this.backgroundNode.setStrokePaint(this.disabledStrokeColor);
        }
        PPath pPath = new PPath(double_);
        pPath.setPickable(false);
        pPath.setOffset(this.shadowOffset, this.shadowOffset);
        pPath.setStroke(null);
        pPath.setPaint(this.enabled ? this.shadowColor : this.disabledShadowColor);
        this.backgroundNode.addChild(pNode);
        double d3 = (double)this.margin.left - PNodeLayoutUtils.getOriginXOffset(pNode);
        double d4 = (double)this.margin.top - PNodeLayoutUtils.getOriginYOffset(pNode);
        pNode.setOffset(d3, d4);
        this.parentNode.addChild(pPath);
        this.parentNode.addChild(this.backgroundNode);
        ButtonEventHandler buttonEventHandler = new ButtonEventHandler();
        this.backgroundNode.addInputEventListener(buttonEventHandler);
        buttonEventHandler.addButtonEventListener(new ButtonEventHandler.ButtonEventListener(){

            public void setFocus(boolean bl) {
                ButtonNode.this.setFocus(bl);
            }

            public void setArmed(boolean bl) {
                ButtonNode.this.setArmed(bl);
            }

            public void fire() {
                ButtonNode.this.notifyActionPerformed();
            }
        });
        if (this.toolTipText != null) {
            this.parentNode.addChild(new ToolTipNode(this.toolTipText, this));
        }
        this.setPickable(this.enabled);
        this.setChildrenPickable(this.enabled);
    }

    protected void setFocus(boolean bl) {
        if (bl != this.focus) {
            this.focus = bl;
            this.updateAppearance();
        }
    }

    protected void setArmed(boolean bl) {
        if (bl != this.armed) {
            this.armed = bl;
            this.updateAppearance();
        }
    }

    private void updateAppearance() {
        if (this.enabled) {
            if (this.armed) {
                this.backgroundNode.setPaint(this.armedGradient);
                this.backgroundNode.setOffset(this.shadowOffset, this.shadowOffset);
            } else {
                this.backgroundNode.setPaint(this.focus ? this.mouseOverGradient : this.mouseNotOverGradient);
                this.backgroundNode.setOffset(0.0, 0.0);
            }
        }
    }

    public void setBackground(Color color) {
        if (!color.equals(this.background)) {
            this.background = color;
            this.update();
        }
    }

    public void setForeground(Color color) {
        if (!color.equals(this.foreground)) {
            this.foreground = color;
            this.update();
        }
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.update();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    protected void notifyActionPerformed() {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.button, UserActions.pressed, this.parameters.apply());
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.actionCommand);
        for (ActionListener actionListener : new ArrayList<ActionListener>(this.actionListeners)) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    protected Paint createMouseNotOverGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(this.background), this.background, d, d2);
    }

    protected Paint createMouseOverGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(ButtonNode.createBrighterColor(this.background)), ButtonNode.createBrighterColor(this.background), d, d2);
    }

    protected Paint createArmedGradient(double d, double d2) {
        return this.createGradient(this.background, ButtonNode.createBrighterColor(this.background), d, d2);
    }

    private Paint createDisabledGradient(double d, double d2) {
        return this.createGradient(ButtonNode.createBrighterColor(this.disabledBackground), this.disabledBackground, d, d2);
    }

    private Paint createGradient(Color color, Color color2, double d, double d2) {
        if (this.useGradient()) {
            return new GradientPaint((float)d / 2.0f, 0.0f, color, (float)d * 0.5f, (float)d2, color2);
        }
        return color2;
    }

    private boolean useGradient() {
        return !PhetUtilities.isMacintosh();
    }

    private static Color createBrighterColor(Color color) {
        int n = color.getRed() + (int)Math.round((double)(255 - color.getRed()) * 0.5);
        int n2 = color.getGreen() + (int)Math.round((double)(255 - color.getGreen()) * 0.5);
        int n3 = color.getBlue() + (int)Math.round((double)(255 - color.getBlue()) * 0.5);
        int n4 = color.getAlpha();
        return new Color(n, n2, n3, n4);
    }

    public void setContentNode(PNode pNode) {
        this.contentNode = pNode;
        this.update();
    }

    public void setDisabledContentNode(PNode pNode) {
        this.disabledContentNode = pNode;
        this.update();
    }

    public void setUserComponent(IUserComponent iUserComponent) {
        this.userComponent = iUserComponent;
    }
}

