/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.components;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserAction;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;

public class SimSharingJTextField
extends JTextField {
    private final IUserComponent userComponent;
    private final ActionListener dummyActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };
    private boolean focusMessagesEnabled = true;
    private boolean keyPressedMessagesEnabled = false;

    public SimSharingJTextField(IUserComponent iUserComponent, int n) {
        super(n);
        this.userComponent = iUserComponent;
        this.init();
    }

    private void init() {
        this.enableFireActionPerformed();
        this.enableMouseEvents();
    }

    private void enableFireActionPerformed() {
        this.addActionListener(this.dummyActionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != this.dummyActionListener) {
            super.removeActionListener(actionListener);
        }
    }

    private void enableMouseEvents() {
        this.enableEvents(16L);
    }

    protected void fireActionPerformed() {
        this.sendUserMessage(UserActions.enterPressed, this.getParameters());
        super.fireActionPerformed();
    }

    protected void processFocusEvent(FocusEvent focusEvent) {
        if (this.focusMessagesEnabled) {
            if (focusEvent.getID() == 1005) {
                this.sendUserMessage(UserActions.focusLost, this.getParameters());
            } else if (focusEvent.getID() == 1004) {
                this.sendUserMessage(UserActions.focusGained, this.getParameters());
            }
        }
        super.processFocusEvent(focusEvent);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this.keyPressedMessagesEnabled && keyEvent.getID() == 401 && keyEvent.getKeyCode() != 10) {
            this.sendUserMessage(UserActions.keyPressed, this.getParameters().with((IParameterKey)ParameterKeys.key, KeyEvent.getKeyText(keyEvent.getKeyCode())));
        }
        super.processKeyEvent(keyEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 && !this.isEnabled()) {
            this.sendUserMessage(UserActions.pressed, ParameterSet.parameterSet((IParameterKey)ParameterKeys.enabled, this.isEnabled()).with((IParameterKey)ParameterKeys.interactive, this.isEnabled()));
        }
        super.processMouseEvent(mouseEvent);
    }

    protected ParameterSet getParameters() {
        return new ParameterSet().with((IParameterKey)ParameterKeys.text, this.getText());
    }

    private void sendUserMessage(IUserAction iUserAction, ParameterSet parameterSet) {
        SimSharingManager.sendUserMessage(this.userComponent, UserComponentTypes.textField, iUserAction, parameterSet);
    }
}

