/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLConstants;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

class SolutionNode
extends PPath {
    private final ConcentrationSolution solution;
    private final Beaker beaker;
    private final Function.LinearFunction volumeToHeightFunction;

    public SolutionNode(ConcentrationSolution concentrationSolution, Beaker beaker) {
        this.setStroke(BLLConstants.FLUID_STROKE);
        this.solution = concentrationSolution;
        this.beaker = beaker;
        this.volumeToHeightFunction = new Function.LinearFunction(0.0, beaker.volume, 0.0, beaker.size.getHeight());
        SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                SolutionNode.this.updateNode();
            }
        };
        concentrationSolution.addFluidColorObserver(simpleObserver);
        concentrationSolution.volume.addObserver(simpleObserver);
        this.addInputEventListener(new NonInteractiveEventHandler(BLLSimSharing.UserComponents.solution));
    }

    private void updateNode() {
        Color color = this.solution.getFluidColor();
        this.setPaint(color);
        this.setStrokePaint(BLLConstants.createFluidStrokeColor(color));
        double d = this.solution.volume.get();
        double d2 = this.volumeToHeightFunction.evaluate(d);
        if (d > 0.0 && d2 < 5.0) {
            d2 = 5.0;
        }
        this.setPathTo(new Rectangle2D.Double(-this.beaker.size.getWidth() / 2.0, -d2, this.beaker.size.getWidth(), d2));
    }
}

