/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.MovableDragHandler;
import edu.colorado.phet.beerslawlab.concentration.model.Shaker;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;

class ShakerNode
extends PhetPNode {
    public ShakerNode(final Shaker shaker) {
        PImage pImage = new PImage(BLLResources.Images.SHAKER){
            {
                this.scale(0.75);
            }
        };
        final HTMLNode hTMLNode = new HTMLNode("", Color.BLACK, new PhetFont(1, 22));
        PNode pNode = new PNode();
        pNode.addChild(pImage);
        pNode.addChild(hTMLNode);
        pImage.setOffset(-pImage.getFullBoundsReference().getWidth() / 2.0, -pImage.getFullBoundsReference().getHeight() / 2.0);
        pNode.rotate(shaker.orientation - Math.PI);
        ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode(pNode);
        this.addChild(zeroOffsetNode);
        zeroOffsetNode.setOffset(-45.0, -170.0);
        shaker.solute.addObserver(new SimpleObserver(){

            public void update() {
                hTMLNode.setHTML(shaker.solute.get().formula);
                hTMLNode.setOffset(-(hTMLNode.getFullBoundsReference().getWidth() / 2.0) + 30.0, -hTMLNode.getFullBoundsReference().getHeight() / 2.0);
            }
        });
        shaker.visible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                ShakerNode.this.setVisible(bl);
            }
        });
        shaker.location.addObserver(new SimpleObserver(){

            public void update() {
                ShakerNode.this.setOffset(((ImmutableVector2D)shaker.location.get()).toPoint2D());
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new MovableDragHandler((IUserComponent)BLLSimSharing.UserComponents.shaker, shaker, this));
    }
}

