/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.concentration.model.PrecipitateParticle;
import edu.colorado.phet.beerslawlab.concentration.model.ShakerParticle;
import edu.colorado.phet.beerslawlab.concentration.model.SoluteParticle;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.geom.Rectangle2D;

abstract class ParticleNode
extends PPath {
    public ParticleNode(SoluteParticle soluteParticle) {
        this.setPaint(soluteParticle.color);
        this.setStrokePaint(soluteParticle.color.darker());
        this.setStroke(new BasicStroke(1.0f));
        this.setPathTo(new Rectangle2D.Double(-soluteParticle.size / 2.0, -soluteParticle.size / 2.0, soluteParticle.size, soluteParticle.size));
        this.setRotation(soluteParticle.orientation);
        this.setOffset(soluteParticle.location.get().getX(), soluteParticle.location.get().getY() - 1.0);
    }

    static class PrecipitateParticleNode
    extends ParticleNode {
        public PrecipitateParticleNode(PrecipitateParticle precipitateParticle) {
            super(precipitateParticle);
        }
    }

    static class ShakerParticleNode
    extends ParticleNode {
        private final ShakerParticle particle;
        private final VoidFunction1<ImmutableVector2D> locationObserver;

        public ShakerParticleNode(ShakerParticle shakerParticle) {
            super(shakerParticle);
            this.particle = shakerParticle;
            this.locationObserver = new VoidFunction1<ImmutableVector2D>(){

                @Override
                public void apply(ImmutableVector2D immutableVector2D) {
                    ShakerParticleNode.this.setOffset(immutableVector2D.toPoint2D());
                }
            };
            shakerParticle.location.addObserver(this.locationObserver);
        }

        public void cleanup() {
            this.particle.location.removeObserver(this.locationObserver);
        }
    }
}

