/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLConstants;
import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.beerslawlab.common.view.MovableDragHandler;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.Dropper;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.PiccoloPhetResources;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.nodes.MomentaryButtonNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DropperNode
extends PhetPNode {
    private static final GeneralPath GLASS_PATH = new DoubleGeneralPath(){
        {
            this.moveTo(-7.5, 0.0);
            this.lineTo(-7.5, -5.0);
            this.lineTo(-23.0, -19.0);
            this.lineTo(-23.0, -150.0);
            this.lineTo(23.0, -150.0);
            this.lineTo(23.0, -19.0);
            this.lineTo(7.5, -5.0);
            this.lineTo(7.5, 0.0);
            this.closePath();
        }
    }.getGeneralPath();

    public DropperNode(final Dropper dropper, final Solvent solvent, final Property<Solute> property) {
        final PPath pPath = new PPath(GLASS_PATH);
        final PImage pImage = new PImage(BLLResources.Images.DROPPER_FOREGROUND);
        final PImage pImage2 = new PImage(BLLResources.Images.DROPPER_BACKGROUND);
        final HTMLNode hTMLNode = new HTMLNode("", Color.BLACK, new PhetFont(1, 15));
        final PPath pPath2 = new PPath(){
            {
                this.setPaint(ColorUtils.createColor(new Color(240, 240, 240), 150));
                this.setStroke(null);
            }
        };
        MomentaryButtonNode momentaryButtonNode = new MomentaryButtonNode(BLLSimSharing.UserComponents.dropperButton, dropper.on, PiccoloPhetResources.getImage("button_pressed.png"), PiccoloPhetResources.getImage("button_unpressed.png"), dropper.enabled, PiccoloPhetResources.getImage("button_pressed_disabled.png"), PiccoloPhetResources.getImage("button_unpressed_disabled.png")){
            {
                this.scale(0.3);
            }
        };
        this.addChild(pPath);
        this.addChild(pImage2);
        this.addChild(pImage);
        this.addChild(pPath2);
        this.addChild(hTMLNode);
        this.addChild(momentaryButtonNode);
        pImage.setOffset(-pImage.getFullBoundsReference().getWidth() / 2.0, -pImage.getFullBoundsReference().getHeight());
        pImage2.setOffset(-pImage2.getFullBoundsReference().getWidth() / 2.0, -pImage2.getFullBoundsReference().getHeight());
        momentaryButtonNode.setOffset(pImage.getFullBoundsReference().getCenterX() - momentaryButtonNode.getFullBoundsReference().getWidth() / 2.0, pImage.getFullBoundsReference().getMinY() + 13.0);
        final RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                hTMLNode.setHTML(dropper.solute.get().formula);
                hTMLNode.setRotation(-1.5707963267948966);
                hTMLNode.setOffset(-(hTMLNode.getFullBoundsReference().getWidth() / 2.0), pImage.getFullBoundsReference().getMaxY() - (pImage.getFullBoundsReference().getHeight() - 130.0) + hTMLNode.getFullBoundsReference().getHeight() / 2.0);
                double d = 1.2 * hTMLNode.getFullBoundsReference().getWidth();
                double d2 = 1.2 * hTMLNode.getFullBoundsReference().getHeight();
                double d3 = hTMLNode.getFullBoundsReference().getCenterX() - d / 2.0;
                double d4 = hTMLNode.getFullBoundsReference().getCenterY() - d2 / 2.0;
                pPath2.setPathTo(new RoundRectangle2D.Double(d3, d4, d, d2, 8.0, 8.0));
                Color color = ConcentrationSolution.createColor(solvent, (Solute)property.get(), ((Solute)property.get()).stockSolutionConcentration);
                pPath.setPaint(color);
                pPath.setStrokePaint(BLLConstants.createFluidStrokeColor(color));
            }
        };
        richSimpleObserver.observe(dropper.solute, dropper.solute.get().colorScheme);
        property.addObserver(new ChangeObserver<Solute>(){

            @Override
            public void update(Solute solute, Solute solute2) {
                solute2.colorScheme.removeObserver(richSimpleObserver);
                solute.colorScheme.addObserver(richSimpleObserver);
            }
        });
        dropper.visible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                DropperNode.this.setVisible(bl);
            }
        });
        dropper.location.addObserver(new SimpleObserver(){

            public void update() {
                DropperNode.this.setOffset(((ImmutableVector2D)dropper.location.get()).toPoint2D());
            }
        });
        dropper.empty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                pPath.setVisible(bl == false);
                pImage2.setVisible(bl);
            }
        });
        this.addInputEventListener(new CursorHandler());
        this.addInputEventListener(new MovableDragHandler((IUserComponent)BLLSimSharing.UserComponents.dropper, dropper, this));
    }
}

