/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.view;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.MovableDragHandler;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationMeter;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.Dropper;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.HorizontalTiledNode;
import edu.colorado.phet.common.piccolophet.simsharing.NonInteractiveEventHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;

class ConcentrationMeterNode
extends PhetPNode {
    private final ConcentrationMeter meter;
    private final ConcentrationSolution solution;
    private final Dropper dropper;
    public final PNode bodyNode;
    private final ProbeNode probeNode;

    public ConcentrationMeterNode(ConcentrationMeter concentrationMeter, ConcentrationSolution concentrationSolution, Dropper dropper, PNode pNode, PNode pNode2, PNode pNode3, PNode pNode4) {
        this.meter = concentrationMeter;
        this.solution = concentrationSolution;
        this.dropper = dropper;
        this.bodyNode = new BodyNode(concentrationMeter);
        this.probeNode = new ProbeNode(concentrationMeter, pNode, pNode3, pNode4, pNode2);
        WireNode wireNode = new WireNode(this.probeNode, this.bodyNode);
        this.addChild(wireNode);
        this.addChild(this.bodyNode);
        this.addChild(this.probeNode);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                ConcentrationMeterNode.this.updateValue();
            }
        };
        richSimpleObserver.observe(concentrationMeter.probe.location, concentrationSolution.solute, concentrationSolution.concentration);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ConcentrationMeterNode.this.updateValue();
            }
        };
        pNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
        pNode3.addPropertyChangeListener("fullBounds", propertyChangeListener);
        pNode4.addPropertyChangeListener("fullBounds", propertyChangeListener);
        pNode2.addPropertyChangeListener("fullBounds", propertyChangeListener);
    }

    private void updateValue() {
        if (this.probeNode.isInSolution()) {
            this.meter.value.set(this.solution.concentration.get());
        } else if (this.probeNode.isInSolvent()) {
            this.meter.value.set(0.0);
        } else if (this.probeNode.isInDrain()) {
            this.meter.value.set(this.solution.concentration.get());
        } else if (this.probeNode.isInStockSolution()) {
            this.meter.value.set(this.dropper.solute.get().stockSolutionConcentration);
        } else {
            this.meter.value.set(null);
        }
    }

    private static class BodyNode
    extends PNode {
        private static final DecimalFormat VALUE_FORMAT = new DecimalFormat("0.000");

        public BodyNode(final ConcentrationMeter concentrationMeter) {
            PText pText = new PText(BLLResources.Strings.CONCENTRATION){
                {
                    this.setTextPaint(Color.WHITE);
                    this.setFont(new PhetFont(1, 18));
                }
            };
            PText pText2 = new PText(MessageFormat.format(BLLResources.Strings.PATTERN_PARENTHESES_0TEXT, BLLResources.Strings.UNITS_MOLES_PER_LITER)){
                {
                    this.setTextPaint(Color.WHITE);
                    this.setFont(new PhetFont(1, 16));
                }
            };
            final PText pText3 = new PText("0.000"){
                {
                    this.setFont(new PhetFont(24));
                }
            };
            double d = Math.max(pText.getFullBoundsReference().getWidth(), Math.max(pText2.getFullBoundsReference().getWidth(), pText3.getFullBoundsReference().getWidth()));
            double d2 = 50.0 + d;
            final HorizontalTiledNode horizontalTiledNode = new HorizontalTiledNode(d2, BLLResources.Images.CONCENTRATION_METER_BODY_LEFT, BLLResources.Images.CONCENTRATION_METER_BODY_CENTER, BLLResources.Images.CONCENTRATION_METER_BODY_RIGHT);
            this.addChild(horizontalTiledNode);
            this.addChild(pText);
            this.addChild(pText2);
            this.addChild(pText3);
            pText.setOffset((horizontalTiledNode.getFullBoundsReference().getWidth() - pText.getFullBoundsReference().getWidth()) / 2.0, 12.0);
            pText2.setOffset((horizontalTiledNode.getFullBoundsReference().getWidth() - pText2.getFullBoundsReference().getWidth()) / 2.0, pText.getFullBoundsReference().getMaxY() + 3.0);
            pText3.setOffset(0.0, 67.0);
            concentrationMeter.body.location.addObserver(new VoidFunction1<ImmutableVector2D>(){

                @Override
                public void apply(ImmutableVector2D immutableVector2D) {
                    BodyNode.this.setOffset(immutableVector2D.toPoint2D());
                }
            });
            concentrationMeter.value.addObserver(new SimpleObserver(){

                public void update() {
                    Double d = concentrationMeter.value.get();
                    if (d == null) {
                        pText3.setText("-");
                        pText3.setOffset(horizontalTiledNode.getFullBoundsReference().getCenterX() - pText3.getFullBoundsReference().getWidth() / 2.0, pText3.getYOffset());
                    } else {
                        pText3.setText(VALUE_FORMAT.format(d));
                        pText3.setOffset(horizontalTiledNode.getFullBoundsReference().getMaxX() - pText3.getFullBoundsReference().getWidth() - 25.0, pText3.getYOffset());
                    }
                }
            });
            this.addInputEventListener(new NonInteractiveEventHandler(BLLSimSharing.UserComponents.concentrationMeterBody));
        }
    }

    private static class ProbeNode
    extends PNode {
        private final ConcentrationMeter meter;
        private final PNode solutionNode;
        private final PNode solventFluidNode;
        private final PNode drainFluidNode;
        private final PNode stockSolutionNode;

        public ProbeNode(ConcentrationMeter concentrationMeter, PNode pNode, PNode pNode2, PNode pNode3, PNode pNode4) {
            this.meter = concentrationMeter;
            this.solutionNode = pNode;
            this.solventFluidNode = pNode2;
            this.drainFluidNode = pNode3;
            this.stockSolutionNode = pNode4;
            PImage pImage = new PImage(BLLResources.Images.CONCENTRATION_METER_PROBE);
            this.addChild(pImage);
            double d = pImage.getFullBoundsReference().getHeight() / 2.0;
            pImage.setOffset(-d, -d);
            concentrationMeter.probe.location.addObserver(new VoidFunction1<ImmutableVector2D>(){

                @Override
                public void apply(ImmutableVector2D immutableVector2D) {
                    ProbeNode.this.setOffset(immutableVector2D.toPoint2D());
                }
            });
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new MovableDragHandler(BLLSimSharing.UserComponents.concentrationMeterProbe, concentrationMeter.probe, this){

                public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
                    return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)BLLSimSharing.ParameterKeys.isInSolution, ProbeNode.this.isInSolution());
                }
            });
        }

        private boolean isInSolution() {
            return this.isInNode(this.solutionNode);
        }

        private boolean isInSolvent() {
            return this.isInNode(this.solventFluidNode);
        }

        private boolean isInDrain() {
            return this.isInNode(this.drainFluidNode);
        }

        private boolean isInStockSolution() {
            return this.isInNode(this.stockSolutionNode);
        }

        private boolean isInNode(PNode pNode) {
            return pNode.getFullBoundsReference().contains(this.meter.probe.location.get().toPoint2D());
        }
    }

    private static class WireNode
    extends PPath {
        private static final Function BODY_CTRL_Y = new Function.LinearFunction(0.0, 800.0, 0.0, 200.0);

        public WireNode(final PNode pNode, final PNode pNode2) {
            this.setStroke(new BasicStroke(8.0f, 2, 1, 1.0f));
            this.setStrokePaint(Color.GRAY);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ImmutableVector2D immutableVector2D = new ImmutableVector2D(pNode2.getFullBoundsReference().getCenterX(), pNode2.getFullBoundsReference().getMaxY() - 10.0);
                    ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(pNode.getFullBoundsReference().getMaxX(), pNode.getFullBoundsReference().getCenterY());
                    ImmutableVector2D immutableVector2D3 = new ImmutableVector2D(0.0, BODY_CTRL_Y.evaluate(pNode2.getFullBoundsReference().getCenterX() - pNode.getFullBoundsReference().getX()));
                    ImmutableVector2D immutableVector2D4 = new ImmutableVector2D(50.0, 0.0);
                    ImmutableVector2D immutableVector2D5 = new ImmutableVector2D(immutableVector2D.getX() + immutableVector2D3.getX(), immutableVector2D.getY() + immutableVector2D3.getY());
                    ImmutableVector2D immutableVector2D6 = new ImmutableVector2D(immutableVector2D2.getX() + immutableVector2D4.getX(), immutableVector2D2.getY() + immutableVector2D4.getY());
                    WireNode.this.setPathTo(new CubicCurve2D.Double(immutableVector2D.getX(), immutableVector2D.getY(), immutableVector2D5.getX(), immutableVector2D5.getY(), immutableVector2D6.getX(), immutableVector2D6.getY(), immutableVector2D2.getX(), immutableVector2D2.getY()));
                }
            };
            pNode.addPropertyChangeListener("fullBounds", propertyChangeListener);
            pNode2.addPropertyChangeListener("fullBounds", propertyChangeListener);
        }
    }
}

