/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSymbols;
import edu.colorado.phet.beerslawlab.concentration.model.SoluteColorScheme;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.awt.Color;

public class Solute {
    public final String name;
    public final String formula;
    public final Property<SoluteColorScheme> colorScheme;
    public final double stockSolutionConcentration;
    private Color particleColor;
    public final double particleSize;
    public final int particlesPerMole;

    public Solute(String string, String string2, SoluteColorScheme soluteColorScheme, double d) {
        this(string, string2, soluteColorScheme, d, 5.0, 200);
    }

    public Solute(String string, String string2, SoluteColorScheme soluteColorScheme, double d, double d2, int n) {
        this.name = string;
        this.formula = string2;
        this.colorScheme = new Property<SoluteColorScheme>(soluteColorScheme);
        this.stockSolutionConcentration = d;
        this.particleColor = soluteColorScheme.maxColor;
        this.particleSize = d2;
        this.particlesPerMole = n;
        this.colorScheme.addObserver(new SimpleObserver(){

            public void update() {
                Solute.this.updateParticleColor();
            }
        });
    }

    protected void updateParticleColor() {
        this.particleColor = this.colorScheme.get().maxColor;
    }

    public String getDisplayName() {
        return this.name;
    }

    public Color getParticleColor() {
        return this.particleColor;
    }

    protected void setParticleColor(Color color) {
        this.particleColor = color;
    }

    public double getSaturatedConcentration() {
        return this.colorScheme.get().maxConcentration;
    }

    public static class CobaltChloride
    extends Solute {
        public CobaltChloride() {
            super(BLLResources.Strings.COBALT_CHLORIDE, BLLSymbols.COBALT_CHLORIDE, new SoluteColorScheme.CobaltChlorideColorScheme(), 4.0);
        }
    }

    public static class CobaltIINitrate
    extends Solute {
        public CobaltIINitrate() {
            super(BLLResources.Strings.COBALT_II_NITRATE, BLLSymbols.COBALT_II_NITRATE, new SoluteColorScheme.CobaltIINitrateColorScheme(), 5.0);
        }
    }

    public static class CopperSulfate
    extends Solute {
        public CopperSulfate() {
            super(BLLResources.Strings.COPPER_SULFATE, BLLSymbols.COPPER_SULFATE, new SoluteColorScheme.CopperSulfateColorScheme(), 1.0);
        }
    }

    public static class DrinkMix
    extends Solute {
        public DrinkMix() {
            super(BLLResources.Strings.DRINK_MIX, BLLSymbols.DRINK_MIX, new SoluteColorScheme.DrinkMixColorScheme(), 5.5);
        }
    }

    public static class NickelIIChloride
    extends Solute {
        public NickelIIChloride() {
            super(BLLResources.Strings.NICKEL_II_CHLORIDE, BLLSymbols.NICKEL_II_CHLORIDE, new SoluteColorScheme.NickelIIChlorideColorScheme(), 5.0);
        }
    }

    public static class PotassiumChromate
    extends Solute {
        public PotassiumChromate() {
            super(BLLResources.Strings.POTASSIUM_CHROMATE, BLLSymbols.POTASSIUM_CHROMATE, new SoluteColorScheme.PotassiumChromateColorScheme(), 3.0);
        }
    }

    public static class PotassiumDichromate
    extends Solute {
        public PotassiumDichromate() {
            super(BLLResources.Strings.POTASSIUM_DICHROMATE, BLLSymbols.POTASSIUM_DICHROMATE, new SoluteColorScheme.PotassiumDichromateColorScheme(), 0.5);
        }
    }

    public static class PotassiumPermanganate
    extends Solute {
        public PotassiumPermanganate() {
            super(BLLResources.Strings.POTASSIUM_PERMANGANATE, BLLSymbols.POTASSIUM_PERMANGANATE, new SoluteColorScheme.PotassiumPermanganateColorScheme(), 0.4);
            this.setParticleColor(Color.BLACK);
        }

        protected void updateParticleColor() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SoluteForm
    extends Enum<SoluteForm> {
        public static final /* enum */ SoluteForm SOLID = new SoluteForm();
        public static final /* enum */ SoluteForm STOCK_SOLUTION = new SoluteForm();
        private static final /* synthetic */ SoluteForm[] $VALUES;

        public static SoluteForm[] values() {
            return (SoluteForm[])$VALUES.clone();
        }

        static {
            $VALUES = new SoluteForm[]{SOLID, STOCK_SOLUTION};
        }
    }
}

