/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.beerslawlab.concentration.model.Shaker;
import edu.colorado.phet.beerslawlab.concentration.model.ShakerParticle;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import java.util.ArrayList;
import java.util.Random;

public class ShakerParticles {
    private final Shaker shaker;
    private final ConcentrationSolution solution;
    private final Beaker beaker;
    private final ArrayList<ParticlesChangeListener> listeners;
    private final ArrayList<ShakerParticle> particles;
    private final Random randomLocation = new Random();

    public ShakerParticles(Shaker shaker, ConcentrationSolution concentrationSolution, Beaker beaker) {
        this.shaker = shaker;
        this.solution = concentrationSolution;
        this.beaker = beaker;
        this.listeners = new ArrayList();
        this.particles = new ArrayList();
        concentrationSolution.solute.addObserver(new SimpleObserver(){

            public void update() {
                ShakerParticles.this.removeAllParticles();
            }
        });
    }

    public void stepInTime(double d) {
        for (ShakerParticle shakerParticle : new ArrayList<ShakerParticle>(this.particles)) {
            shakerParticle.stepInTime(d, this.beaker);
            double d2 = this.solution.volume.get() / this.beaker.volume;
            double d3 = this.beaker.location.getY() - d2 * this.beaker.size.getHeight() - this.solution.solute.get().particleSize;
            if (!(((ImmutableVector2D)shakerParticle.location.get()).getY() > d3)) continue;
            this.removeParticle(shakerParticle);
            this.solution.soluteAmount.set(this.solution.soluteAmount.get() + 1.0 / (double)this.solution.solute.get().particlesPerMole);
        }
        if (this.shaker.getDispensingRate() > 0.0) {
            int n = (int)Math.max(1.0, this.shaker.getDispensingRate() * (double)this.solution.solute.get().particlesPerMole * d);
            for (int i = 0; i < n; ++i) {
                this.addParticle(new ShakerParticle(this.solution.solute.get(), this.getRandomLocation(), this.getRandomOrientation(), this.getInitialVelocity(), this.getGravitationalAcceleration()));
            }
        }
    }

    protected ImmutableVector2D getInitialVelocity() {
        return ImmutableVector2D.createPolar(100.0, this.shaker.orientation);
    }

    private ImmutableVector2D getGravitationalAcceleration() {
        return new ImmutableVector2D(0.0, 150.0);
    }

    private double getRandomOrientation() {
        return Math.random() * Math.PI;
    }

    private ImmutableVector2D getRandomLocation() {
        double d = this.randomLocation.nextInt(40) - 20;
        double d2 = this.randomLocation.nextInt(5);
        return new ImmutableVector2D(this.shaker.getX() + d, this.shaker.getY() + d2);
    }

    public void addParticlesChangeListener(ParticlesChangeListener particlesChangeListener) {
        this.listeners.add(particlesChangeListener);
    }

    private void addParticle(ShakerParticle shakerParticle) {
        this.particles.add(shakerParticle);
        this.fireParticleAdded(shakerParticle);
    }

    private void removeParticle(ShakerParticle shakerParticle) {
        this.particles.remove(shakerParticle);
        this.fireParticleRemoved(shakerParticle);
    }

    public void removeAllParticles() {
        for (ShakerParticle shakerParticle : new ArrayList<ShakerParticle>(this.particles)) {
            this.removeParticle(shakerParticle);
        }
    }

    private void fireParticleAdded(ShakerParticle shakerParticle) {
        for (ParticlesChangeListener particlesChangeListener : new ArrayList<ParticlesChangeListener>(this.listeners)) {
            particlesChangeListener.particleAdded(shakerParticle);
        }
    }

    private void fireParticleRemoved(ShakerParticle shakerParticle) {
        for (ParticlesChangeListener particlesChangeListener : new ArrayList<ParticlesChangeListener>(this.listeners)) {
            particlesChangeListener.particleRemoved(shakerParticle);
        }
    }

    public static interface ParticlesChangeListener {
        public void particleAdded(ShakerParticle var1);

        public void particleRemoved(ShakerParticle var1);
    }
}

