/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.concentration.model.Beaker;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.beerslawlab.concentration.model.SoluteParticle;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;

public class ShakerParticle
extends SoluteParticle {
    private Solute solute;
    private ImmutableVector2D velocity;
    private ImmutableVector2D acceleration;

    public ShakerParticle(Solute solute, ImmutableVector2D immutableVector2D, double d, ImmutableVector2D immutableVector2D2, ImmutableVector2D immutableVector2D3) {
        super(solute.getParticleColor(), solute.particleSize, immutableVector2D, d);
        this.solute = solute;
        this.velocity = immutableVector2D2;
        this.acceleration = immutableVector2D3;
    }

    public void stepInTime(double d, Beaker beaker) {
        this.velocity = this.velocity.plus(this.acceleration.times(d));
        ImmutableVector2D immutableVector2D = ((ImmutableVector2D)this.location.get()).plus(this.velocity.times(d));
        double d2 = beaker.getMinX() + this.solute.particleSize;
        if (immutableVector2D.getX() <= d2) {
            immutableVector2D = new ImmutableVector2D(d2, immutableVector2D.getY());
            this.velocity = new ImmutableVector2D(Math.abs(this.velocity.getX()), this.velocity.getY());
        }
        this.location.set(immutableVector2D);
    }
}

