/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.concentration.model.ConcentrationSolution;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;

public class Evaporator
implements Resettable {
    public final double maxEvaporationRate;
    public final Property<Double> evaporationRate;
    public final Property<Boolean> enabled;

    public Evaporator(double d, final ConcentrationSolution concentrationSolution) {
        this.maxEvaporationRate = d;
        this.evaporationRate = new Property<Double>(0.0);
        this.enabled = new Property<Boolean>(true);
        concentrationSolution.volume.addObserver(new SimpleObserver(){

            public void update() {
                Evaporator.this.enabled.set(concentrationSolution.volume.get() > 0.0);
            }
        });
        this.enabled.addObserver(new SimpleObserver(){

            public void update() {
                if (!Evaporator.this.enabled.get().booleanValue()) {
                    Evaporator.this.evaporationRate.set(0.0);
                }
            }
        });
    }

    public void reset() {
        this.evaporationRate.reset();
        this.enabled.reset();
    }
}

