/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.concentration.model;

import edu.colorado.phet.beerslawlab.common.model.IFluid;
import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.beerslawlab.concentration.model.Solute;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcentrationSolution
implements IFluid,
Resettable {
    public final Solvent solvent = new Solvent.Water();
    public final Property<Solute> solute;
    public final Property<Double> soluteAmount;
    public final Property<Double> volume;
    public final CompositeProperty<Double> concentration;
    public final CompositeProperty<Double> precipitateAmount;
    private final Property<Color> fluidColor;

    public ConcentrationSolution(Property<Solute> property, double d, double d2) {
        this.solute = property;
        this.soluteAmount = new Property<Double>(d);
        this.volume = new Property<Double>(d2);
        this.fluidColor = new Property<Color>(Color.WHITE);
        this.concentration = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                double d = ConcentrationSolution.this.volume.get();
                double d2 = ConcentrationSolution.this.soluteAmount.get();
                if (d > 0.0) {
                    return Math.min(ConcentrationSolution.this.getSaturatedConcentration(), d2 / d);
                }
                return 0.0;
            }
        }, this.solute, this.soluteAmount, this.volume);
        this.precipitateAmount = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                double d = ConcentrationSolution.this.volume.get();
                double d2 = ConcentrationSolution.this.soluteAmount.get();
                if (d > 0.0) {
                    return Math.max(0.0, d * (ConcentrationSolution.this.soluteAmount.get() / d - ConcentrationSolution.this.getSaturatedConcentration()));
                }
                return d2;
            }
        }, this.solute, this.soluteAmount, this.volume);
        final RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                ConcentrationSolution.this.updateFluidColor();
            }
        };
        richSimpleObserver.observe(this.solvent.color, this.solute, this.concentration, property.get().colorScheme);
        property.addObserver(new ChangeObserver<Solute>(){

            @Override
            public void update(Solute solute, Solute solute2) {
                solute2.colorScheme.removeObserver(richSimpleObserver);
                solute.colorScheme.addObserver(richSimpleObserver);
            }
        });
    }

    private void updateFluidColor() {
        this.fluidColor.set(ConcentrationSolution.createColor(this.solvent, this.solute.get(), this.concentration.get()));
    }

    public double getSaturatedConcentration() {
        return this.solute.get().getSaturatedConcentration();
    }

    public boolean isSaturated() {
        boolean bl = false;
        if (this.volume.get() > 0.0) {
            bl = this.soluteAmount.get() / this.volume.get() > this.getSaturatedConcentration();
        }
        return bl;
    }

    @Override
    public Color getFluidColor() {
        return this.fluidColor.get();
    }

    @Override
    public void addFluidColorObserver(SimpleObserver simpleObserver) {
        this.fluidColor.addObserver(simpleObserver);
    }

    public int getNumberOfPrecipitateParticles() {
        int n = (int)((double)this.solute.get().particlesPerMole * this.precipitateAmount.get());
        if (n == 0 && this.precipitateAmount.get() > 0.0) {
            n = 1;
        }
        return n;
    }

    @Override
    public void reset() {
        this.soluteAmount.reset();
        this.volume.reset();
    }

    public static final Color createColor(Solvent solvent, Solute solute, double d) {
        Color color = solvent.color.get();
        if (d > 0.0) {
            color = solute.colorScheme.get().interpolateLinear(d);
        }
        return color;
    }
}

