/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.common.view;

import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.model.Movable;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class MovableDragHandler
extends SimSharingDragHandler {
    private final Movable movable;
    private final PNode dragNode;
    private final ModelViewTransform mvt;
    private double clickXOffset;
    private double clickYOffset;

    public MovableDragHandler(IUserComponent iUserComponent, Movable movable, PNode pNode) {
        this(iUserComponent, movable, pNode, ModelViewTransform.createIdentity());
    }

    public MovableDragHandler(IUserComponent iUserComponent, Movable movable, PNode pNode, ModelViewTransform modelViewTransform) {
        super(iUserComponent, UserComponentTypes.sprite);
        this.movable = movable;
        this.dragNode = pNode;
        this.mvt = modelViewTransform;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        super.startDrag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        this.clickXOffset = point2D.getX() - this.mvt.modelToViewDeltaX(this.movable.location.get().getX());
        this.clickYOffset = point2D.getY() - this.mvt.modelToViewDeltaY(this.movable.location.get().getY());
    }

    protected void drag(PInputEvent pInputEvent) {
        super.drag(pInputEvent);
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.dragNode.getParent());
        double d = this.mvt.viewToModelDeltaX(point2D.getX() - this.clickXOffset);
        double d2 = this.mvt.viewToModelDeltaY(point2D.getY() - this.clickYOffset);
        this.movable.location.set(MovableDragHandler.constrainToBounds(d, d2, this.movable.getDragBounds()));
    }

    public ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
        return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)BLLSimSharing.ParameterKeys.locationX, (int)this.movable.location.get().getX()).with((IParameterKey)BLLSimSharing.ParameterKeys.locationY, (int)this.movable.location.get().getY());
    }

    private static ImmutableVector2D constrainToBounds(double d, double d2, Rectangle2D rectangle2D) {
        ImmutableVector2D immutableVector2D;
        if (rectangle2D != null && !rectangle2D.contains(d, d2)) {
            double d3 = Math.max(Math.min(d, rectangle2D.getMaxX()), rectangle2D.getX());
            double d4 = Math.max(Math.min(d2, rectangle2D.getMaxY()), rectangle2D.getY());
            immutableVector2D = new ImmutableVector2D(d3, d4);
        } else {
            immutableVector2D = new ImmutableVector2D(d, d2);
        }
        return immutableVector2D;
    }
}

