/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.beerslawlab.common.view.SoluteItemNode;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.ComboBoxNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.text.MessageFormat;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SolutionChoiceNode
extends PhetPNode {
    private final SolutionComboBoxNode comboBoxNode;

    public SolutionChoiceNode(ArrayList<BeersLawSolution> arrayList, final Property<BeersLawSolution> property) {
        PText pText = new PText(MessageFormat.format(BLLResources.Strings.PATTERN_0LABEL, BLLResources.Strings.SOLUTION)){
            {
                this.setFont(new PhetFont(18));
            }
        };
        this.addChild(pText);
        this.comboBoxNode = new SolutionComboBoxNode(arrayList, property.get());
        this.addChild(this.comboBoxNode);
        double d = this.comboBoxNode.getFullBoundsReference().getHeight() - pText.getFullBoundsReference().getHeight();
        pText.setOffset(0.0, Math.max(0.0, d / 2.0));
        this.comboBoxNode.setOffset(pText.getFullBoundsReference().getMaxX() + 5.0, Math.min(0.0, d / 2.0));
        property.addObserver(new VoidFunction1<BeersLawSolution>(){

            @Override
            public void apply(BeersLawSolution beersLawSolution) {
                ((SolutionChoiceNode)SolutionChoiceNode.this).comboBoxNode.selectedItem.set(beersLawSolution);
            }
        });
        this.comboBoxNode.selectedItem.addObserver(new VoidFunction1<BeersLawSolution>(){

            @Override
            public void apply(BeersLawSolution beersLawSolution) {
                property.set(beersLawSolution);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SolutionComboBoxNode
    extends ComboBoxNode<BeersLawSolution> {
        public SolutionComboBoxNode(ArrayList<BeersLawSolution> arrayList, BeersLawSolution beersLawSolution) {
            super(BLLSimSharing.UserComponents.solutionComboBox, new Function1<BeersLawSolution, String>(){

                @Override
                public String apply(BeersLawSolution beersLawSolution) {
                    return beersLawSolution.getDisplayName();
                }
            }, arrayList, beersLawSolution, new Function1<BeersLawSolution, PNode>(){

                @Override
                public PNode apply(BeersLawSolution beersLawSolution) {
                    return new SoluteItemNode(new Property<Color>(beersLawSolution.saturatedColor), beersLawSolution.getDisplayName());
                }
            });
        }
    }
}

