/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.beerslaw.model.ConcentrationTransform;
import edu.colorado.phet.beerslawlab.common.BLLSimSharing;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterKeys;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.event.HighlightHandler;
import edu.colorado.phet.common.piccolophet.event.SliderThumbDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.simsharing.SimSharingDragHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.NumberFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConcentrationSliderNode
extends PhetPNode {
    private static final PDimension TRACK_SIZE = new PDimension(200.0, 15.0);
    private static final PDimension THUMB_SIZE = new PDimension(15.0, 35.0);
    private static final Stroke THUMB_STROKE = new BasicStroke(1.0f);
    private static final Color THUMB_NORMAL_COLOR = new Color(89, 156, 212);
    private static final Color THUMB_HIGHLIGHT_COLOR = THUMB_NORMAL_COLOR.brighter();
    private static final Color THUMB_STROKE_COLOR = Color.BLACK;
    private static final Color THUMB_CENTER_LINE_COLOR = Color.WHITE;
    private static final PhetFont TICK_FONT = new PhetFont(12);
    private static final NumberFormat TICK_FORMAT = new DefaultDecimalFormat("0");

    public ConcentrationSliderNode(final Property<BeersLawSolution> property) {
        TrackNode trackNode = new TrackNode(BLLSimSharing.UserComponents.concentrationSliderTrack, TRACK_SIZE, property);
        ThumbNode thumbNode = new ThumbNode(BLLSimSharing.UserComponents.concentrationSliderThumb, THUMB_SIZE, TRACK_SIZE, this, trackNode, property);
        final TickNode tickNode = new TickNode(property.get().concentrationRange.getMin());
        final TickNode tickNode2 = new TickNode(property.get().concentrationRange.getMax());
        this.addChild(tickNode2);
        this.addChild(tickNode);
        this.addChild(trackNode);
        this.addChild(thumbNode);
        tickNode.setOffset(0.0, trackNode.getFullBoundsReference().getMaxY());
        tickNode2.setOffset(TRACK_SIZE.getWidth(), trackNode.getFullBoundsReference().getMaxY());
        thumbNode.setOffset(thumbNode.getXOffset(), trackNode.getFullBoundsReference().getCenterY());
        property.addObserver(new SimpleObserver(){

            public void update() {
                DoubleRange doubleRange = ((BeersLawSolution)property.get()).concentrationRange;
                ConcentrationTransform concentrationTransform = ((BeersLawSolution)property.get()).concentrationTransform;
                tickNode.setValue(concentrationTransform.modelToView(doubleRange.getMin()));
                tickNode2.setValue(concentrationTransform.modelToView(doubleRange.getMax()));
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbDragHandler
    extends SliderThumbDragHandler {
        private final Property<Double> modelValue;

        public ThumbDragHandler(IUserComponent iUserComponent, PNode pNode, PNode pNode2, PNode pNode3, DoubleRange doubleRange, final Property<Double> property) {
            super(iUserComponent, false, SliderThumbDragHandler.Orientation.HORIZONTAL, pNode, pNode2, pNode3, doubleRange, new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    property.set(d);
                }
            });
            this.modelValue = property;
        }

        @Override
        protected ParameterSet getParametersForAllEvents(PInputEvent pInputEvent) {
            return super.getParametersForAllEvents(pInputEvent).with((IParameterKey)ParameterKeys.value, this.modelValue.get());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThumbNode
    extends PComposite {
        private Function modelToView;
        private ThumbDragHandler dragHandler;

        public ThumbNode(final IUserComponent iUserComponent, final PDimension pDimension, final PDimension pDimension2, final PNode pNode, final PNode pNode2, Property<BeersLawSolution> property) {
            PPath pPath = new PPath(){
                {
                    double d = 0.25 * pDimension.getWidth();
                    this.setPathTo(new RoundRectangle2D.Double(-pDimension.getWidth() / 2.0, -pDimension.getHeight() / 2.0, pDimension.getWidth(), pDimension.getHeight(), d, d));
                    this.setPaint(THUMB_NORMAL_COLOR);
                    this.setStroke(THUMB_STROKE);
                    this.setStrokePaint(THUMB_STROKE_COLOR);
                }
            };
            PPath pPath2 = new PPath(){
                {
                    this.setPathTo(new Line2D.Double(0.0, -(pDimension.getHeight() / 2.0) + 3.0, 0.0, pDimension.getHeight() / 2.0 - 3.0));
                    this.setStrokePaint(THUMB_CENTER_LINE_COLOR);
                }
            };
            this.addChild(pPath);
            this.addChild(pPath2);
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new HighlightHandler.PaintHighlightHandler(pPath, THUMB_NORMAL_COLOR, THUMB_HIGHLIGHT_COLOR));
            final VoidFunction1<BeersLawSolution> voidFunction1 = new VoidFunction1<BeersLawSolution>(){

                @Override
                public void apply(BeersLawSolution beersLawSolution) {
                    if (ThumbNode.this.dragHandler != null) {
                        ThumbNode.this.removeInputEventListener(ThumbNode.this.dragHandler);
                    }
                    ThumbNode.this.dragHandler = new ThumbDragHandler(iUserComponent, pNode, pNode2, ThumbNode.this, beersLawSolution.concentrationRange, beersLawSolution.concentration);
                    ThumbNode.this.addInputEventListener(ThumbNode.this.dragHandler);
                    ThumbNode.this.modelToView = new Function.LinearFunction(beersLawSolution.concentrationRange.getMin(), beersLawSolution.concentrationRange.getMax(), 0.0, pDimension2.getWidth());
                }
            };
            voidFunction1.apply(property.get());
            final VoidFunction1<Double> voidFunction12 = new VoidFunction1<Double>(){

                @Override
                public void apply(Double d) {
                    ThumbNode.this.setOffset(ThumbNode.this.modelToView.evaluate(d), ThumbNode.this.getYOffset());
                }
            };
            property.get().concentration.addObserver(voidFunction12);
            property.addObserver(new ChangeObserver<BeersLawSolution>(){

                @Override
                public void update(BeersLawSolution beersLawSolution, BeersLawSolution beersLawSolution2) {
                    voidFunction1.apply(beersLawSolution);
                    beersLawSolution2.concentration.removeObserver(voidFunction12);
                    beersLawSolution.concentration.addObserver(voidFunction12);
                }
            });
        }
    }

    private static class TickNode
    extends PComposite {
        private final PPath tickNode = new PPath(new Line2D.Double(0.0, 0.0, 0.0, 8.0));
        private final PText textNode;

        public TickNode(double d) {
            this.addChild(this.tickNode);
            this.textNode = new PhetPText(TICK_FONT);
            this.addChild(this.textNode);
            this.setValue(d);
        }

        public void setValue(double d) {
            this.textNode.setText(TICK_FORMAT.format(d));
            this.textNode.setOffset(this.tickNode.getFullBoundsReference().getCenterX() - this.textNode.getFullBoundsReference().getWidth() / 2.0, this.tickNode.getFullBoundsReference().getMaxY() + 2.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TrackNode
    extends PPath {
        private Function viewToModel;

        public TrackNode(IUserComponent iUserComponent, final PDimension pDimension, final Property<BeersLawSolution> property) {
            this.setPathTo(new Rectangle2D.Double(0.0, 0.0, pDimension.getWidth(), pDimension.getHeight()));
            this.addInputEventListener(new CursorHandler());
            this.addInputEventListener(new SimSharingDragHandler(iUserComponent, UserComponentTypes.slider){

                protected void startDrag(PInputEvent pInputEvent) {
                    super.startDrag(pInputEvent);
                    this.handleEvent(pInputEvent);
                }

                public void drag(PInputEvent pInputEvent) {
                    super.drag(pInputEvent);
                    this.handleEvent(pInputEvent);
                }

                private void handleEvent(PInputEvent pInputEvent) {
                    double d = pInputEvent.getPositionRelativeTo(TrackNode.this).getX();
                    double d2 = TrackNode.this.viewToModel.evaluate(d);
                    ((BeersLawSolution)property.get()).concentration.set(d2);
                }
            });
            property.addObserver(new VoidFunction1<BeersLawSolution>(){

                @Override
                public void apply(BeersLawSolution beersLawSolution) {
                    DoubleRange doubleRange = beersLawSolution.concentrationRange;
                    TrackNode.this.viewToModel = new Function.LinearFunction(0.0, pDimension.getWidth(), doubleRange.getMin(), doubleRange.getMax());
                    TrackNode.this.setPaint(TrackNode.createPaint(beersLawSolution, pDimension.getWidth()));
                }
            });
        }

        private static Paint createPaint(BeersLawSolution beersLawSolution, double d) {
            return new GradientPaint(0.0f, 0.0f, beersLawSolution.colorRange.getMin(), (float)d, 0.0f, beersLawSolution.colorRange.getMax());
        }
    }
}

