/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.view;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawModel;
import edu.colorado.phet.beerslawlab.beerslaw.view.ATDetectorNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.BLLRulerNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.BeamNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.CuvetteNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.LightNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.SolutionControlsNode;
import edu.colorado.phet.beerslawlab.beerslaw.view.WavelengthControlNode;
import edu.colorado.phet.beerslawlab.common.view.BLLCanvas;
import edu.colorado.phet.beerslawlab.common.view.DebugLocationNode;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.piccolophet.nodes.ResetAllButtonNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Frame;

public class BeersLawCanvas
extends BLLCanvas
implements Resettable {
    private final WavelengthControlNode wavelengthControlNode;

    public BeersLawCanvas(BeersLawModel beersLawModel, Frame frame) {
        LightNode lightNode = new LightNode(beersLawModel.light, beersLawModel.mvt);
        this.wavelengthControlNode = new WavelengthControlNode(beersLawModel.solution, beersLawModel.light);
        SolutionControlsNode solutionControlsNode = new SolutionControlsNode(beersLawModel.getSolutions(), beersLawModel.solution);
        ResetAllButtonNode resetAllButtonNode = new ResetAllButtonNode(new Resettable[]{this, beersLawModel}, frame, 18, Color.BLACK, Color.ORANGE){
            {
                this.setConfirmationEnabled(false);
            }
        };
        BLLRulerNode bLLRulerNode = new BLLRulerNode(beersLawModel.ruler, beersLawModel.mvt);
        CuvetteNode cuvetteNode = new CuvetteNode(beersLawModel.cuvette, beersLawModel.solution, beersLawModel.mvt, 0.1);
        ATDetectorNode aTDetectorNode = new ATDetectorNode(beersLawModel.detector, beersLawModel.mvt);
        DebugLocationNode debugLocationNode = new DebugLocationNode(beersLawModel.mvt);
        BeamNode beamNode = new BeamNode(beersLawModel.beam, beersLawModel.mvt);
        this.addChild(this.wavelengthControlNode);
        this.addChild(aTDetectorNode);
        this.addChild(cuvetteNode);
        this.addChild(beamNode);
        this.addChild(lightNode);
        this.addChild(bLLRulerNode);
        this.addChild(resetAllButtonNode);
        this.addChild(solutionControlsNode);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.addChild(debugLocationNode);
        }
        this.wavelengthControlNode.setOffset(lightNode.getFullBoundsReference().getMinX(), lightNode.getFullBoundsReference().getMaxY() + 20.0);
        solutionControlsNode.setOffset((this.getStageSize().getWidth() - solutionControlsNode.getFullBoundsReference().getWidth()) / 2.0, 20.0);
        ((PNode)resetAllButtonNode).setOffset(this.getStageSize().getWidth() - resetAllButtonNode.getFullBoundsReference().getWidth() - 20.0, this.getStageSize().getHeight() - resetAllButtonNode.getFullBoundsReference().getHeight() - 20.0);
        debugLocationNode.setOffset(950.0, 50.0);
        PNode pNode = aTDetectorNode.bodyNode;
        if (pNode.getFullBoundsReference().getMaxX() > this.getStageSize().getWidth()) {
            double d = beersLawModel.mvt.viewToModelDeltaX(this.getStageSize().getWidth() - pNode.getFullBoundsReference().getWidth() - 4.0);
            double d2 = beersLawModel.detector.body.location.get().getY();
            beersLawModel.detector.body.location.set(new ImmutableVector2D(d, d2));
        }
    }

    public void reset() {
        this.wavelengthControlNode.reset();
    }
}

