/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.common.BLLResources;

public class ConcentrationTransform {
    private final double scale;
    private final String units;

    public ConcentrationTransform(int n) {
        if (n % 10 != 0) {
            throw new IllegalArgumentException("scale must be a power of 10: " + n);
        }
        this.scale = n;
        this.units = ConcentrationTransform.scaleToUnits(n);
    }

    public String getUnits() {
        return this.units;
    }

    public double modelToView(double d) {
        return d * this.scale;
    }

    public double viewToModel(double d) {
        return d / this.scale;
    }

    private static String scaleToUnits(int n) {
        if (n == 1) {
            return BLLResources.Strings.UNITS_M;
        }
        if (n == 1000) {
            return BLLResources.Strings.UNITS_mM;
        }
        if (n == 1000000) {
            return BLLResources.Strings.UNITS_uM;
        }
        throw new IllegalArgumentException("unsupported scale=" + n);
    }
}

