/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.ConcentrationTransform;
import edu.colorado.phet.beerslawlab.beerslaw.model.MolarAbsorptivityData;
import edu.colorado.phet.beerslawlab.common.BLLResources;
import edu.colorado.phet.beerslawlab.common.BLLSymbols;
import edu.colorado.phet.beerslawlab.common.model.Solvent;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.ColorRange;
import edu.colorado.phet.common.phetcommon.util.DoubleRange;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import java.awt.Color;
import java.text.MessageFormat;

public abstract class BeersLawSolution
implements Resettable {
    public final Solvent solvent = new Solvent.Water();
    public final String name;
    public final String formula;
    public final Property<Double> concentration;
    public final DoubleRange concentrationRange;
    public final ConcentrationTransform concentrationTransform;
    public final ColorRange colorRange;
    public final Color saturatedColor;
    public final CompositeProperty<Color> fluidColor;
    public final MolarAbsorptivityData molarAbsorptivityData;

    public BeersLawSolution(String string, String string2, DoubleRange doubleRange, int n, ColorRange colorRange, MolarAbsorptivityData molarAbsorptivityData) {
        this(string, string2, doubleRange, n, colorRange, colorRange.getMax(), molarAbsorptivityData);
    }

    public BeersLawSolution(String string, String string2, DoubleRange doubleRange, int n, ColorRange colorRange, Color color, MolarAbsorptivityData molarAbsorptivityData) {
        this.name = string;
        this.formula = string2;
        this.concentration = new Property<Double>(doubleRange.getDefault());
        this.concentrationRange = doubleRange;
        this.concentrationTransform = new ConcentrationTransform(n);
        this.colorRange = colorRange;
        this.saturatedColor = color;
        this.molarAbsorptivityData = molarAbsorptivityData;
        this.fluidColor = new CompositeProperty<Color>(new Function0<Color>(){

            @Override
            public Color apply() {
                return BeersLawSolution.createColor(BeersLawSolution.this.concentration.get(), BeersLawSolution.this.concentrationRange, BeersLawSolution.this.colorRange, BeersLawSolution.this.solvent);
            }
        }, this.concentration);
    }

    public void reset() {
        this.concentration.reset();
    }

    public String getDisplayName() {
        return MessageFormat.format(BLLResources.Strings.PATTERN_0FORMULA_1NAME, this.formula, this.name);
    }

    public String getViewUnits() {
        return this.concentrationTransform.getUnits();
    }

    private static final Color createColor(double d, DoubleRange doubleRange, ColorRange colorRange, Solvent solvent) {
        Color color = solvent.color.get();
        if (d > 0.0) {
            Function.LinearFunction linearFunction = new Function.LinearFunction(doubleRange.getMin(), doubleRange.getMax(), 0.0, 1.0);
            color = colorRange.interpolateLinear(linearFunction.evaluate(d));
        }
        return color;
    }

    public static class CobaltChlorideSolution
    extends BeersLawSolution {
        public CobaltChlorideSolution() {
            super(BLLResources.Strings.COBALT_CHLORIDE, BLLSymbols.COBALT_CHLORIDE, new DoubleRange(0.0, 0.25, 0.1), 1000, new ColorRange(new Color(255, 242, 242), new Color(255, 106, 106)), new MolarAbsorptivityData.CobaltChlorideData());
        }
    }

    public static class CobaltIINitrateSolution
    extends BeersLawSolution {
        public CobaltIINitrateSolution() {
            super(BLLResources.Strings.COBALT_II_NITRATE, BLLSymbols.COBALT_II_NITRATE, new DoubleRange(0.0, 0.4, 0.1), 1000, new ColorRange(new Color(255, 225, 225), Color.RED), new MolarAbsorptivityData.CobaltIINitrateData());
        }
    }

    public static class CopperSulfateSolution
    extends BeersLawSolution {
        public CopperSulfateSolution() {
            super(BLLResources.Strings.COPPER_SULFATE, BLLSymbols.COPPER_SULFATE, new DoubleRange(0.0, 0.2, 0.1), 1000, new ColorRange(new Color(222, 238, 255), new Color(30, 144, 255)), new MolarAbsorptivityData.CopperSulfateData());
        }
    }

    public static class DrinkMixSolution
    extends BeersLawSolution {
        public DrinkMixSolution() {
            super(BLLResources.Strings.DRINK_MIX, BLLSymbols.DRINK_MIX, new DoubleRange(0.0, 0.4, 0.1), 1000, new ColorRange(new Color(255, 225, 225), Color.RED), new MolarAbsorptivityData.DrinkMixData());
        }

        public String getDisplayName() {
            return this.name;
        }
    }

    public static class NickelIIChlorideSolution
    extends BeersLawSolution {
        public NickelIIChlorideSolution() {
            super(BLLResources.Strings.NICKEL_II_CHLORIDE, BLLSymbols.NICKEL_II_CHLORIDE, new DoubleRange(0.0, 0.35, 0.1), 1000, new ColorRange(new Color(234, 244, 234), new Color(0, 128, 0)), new MolarAbsorptivityData.NickelIIChlorideData());
        }
    }

    public static class PotassiumChromateSolution
    extends BeersLawSolution {
        public PotassiumChromateSolution() {
            super(BLLResources.Strings.POTASSIUM_CHROMATE, BLLSymbols.POTASSIUM_CHROMATE, new DoubleRange(0.0, 4.0E-4, 1.0E-4), 1000000, new ColorRange(new Color(255, 255, 199), new Color(255, 255, 0)), new MolarAbsorptivityData.PotassiumChromateData());
        }
    }

    public static class PotassiumDichromateSolution
    extends BeersLawSolution {
        public PotassiumDichromateSolution() {
            super(BLLResources.Strings.POTASSIUM_DICHROMATE, BLLSymbols.POTASSIUM_DICHROMATE, new DoubleRange(0.0, 5.0E-4, 1.0E-4), 1000000, new ColorRange(new Color(255, 232, 210), new Color(255, 127, 0)), new MolarAbsorptivityData.PotassiumDichromateData());
        }
    }

    public static class PotassiumPermanganateSolution
    extends BeersLawSolution {
        public PotassiumPermanganateSolution() {
            super(BLLResources.Strings.POTASSIUM_PERMANGANATE, BLLSymbols.POTASSIUM_PERMANGANATE, new DoubleRange(0.0, 8.0E-4, 1.0E-4), 1000000, new ColorRange(new Color(255, 235, 255), new Color(255, 0, 255)), new Color(80, 0, 120), new MolarAbsorptivityData.PotassiumPermanganateData());
        }
    }
}

