/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.ATDetector;
import edu.colorado.phet.beerslawlab.beerslaw.model.Absorbance;
import edu.colorado.phet.beerslawlab.beerslaw.model.Cuvette;
import edu.colorado.phet.beerslawlab.beerslaw.model.Light;
import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.ColorUtils;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;

public class Beam {
    private static final Function TRANSMITTANCE_TO_ALPHA = new Function.LinearFunction(0.0, 1.0, 20.0, 200.0);
    private final Light light;
    private final Cuvette cuvette;
    private final ATDetector detector;
    private final Absorbance absorbance;
    private final ModelViewTransform mvt;
    public final Property<ImmutableRectangle2D> shape;
    public final Property<Paint> paint;
    public final CompositeProperty<Boolean> visible;

    public Beam(final Light light, Cuvette cuvette, ATDetector aTDetector, Absorbance absorbance, ModelViewTransform modelViewTransform) {
        this.light = light;
        this.cuvette = cuvette;
        this.detector = aTDetector;
        this.absorbance = absorbance;
        this.mvt = modelViewTransform;
        this.shape = new Property<ImmutableRectangle2D>(new ImmutableRectangle2D(0.0, 0.0));
        this.paint = new Property<Color>(Color.WHITE);
        this.visible = new CompositeProperty<Boolean>(new Function0<Boolean>(){

            @Override
            public Boolean apply() {
                return light.on.get();
            }
        }, light.on);
        RichSimpleObserver richSimpleObserver = new RichSimpleObserver(){

            public void update() {
                if (Beam.this.visible.get().booleanValue()) {
                    Beam.this.updateShape();
                }
            }
        };
        richSimpleObserver.observe(cuvette.width, aTDetector.probe.location);
        RichSimpleObserver richSimpleObserver2 = new RichSimpleObserver(){

            public void update() {
                if (Beam.this.visible.get().booleanValue()) {
                    Beam.this.updateColor();
                }
            }
        };
        richSimpleObserver2.observe(light.wavelength, cuvette.width, absorbance.value);
        this.visible.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                if (bl.booleanValue()) {
                    Beam.this.updateColor();
                    Beam.this.updateShape();
                }
            }
        });
    }

    private void updateColor() {
        double d = this.light.wavelength.get();
        Double d2 = this.absorbance.getTransmittance();
        Color color = ColorUtils.createColor(new VisibleColor(d), 200);
        Color color2 = ColorUtils.createColor(new VisibleColor(d), (int)TRANSMITTANCE_TO_ALPHA.evaluate(d2));
        double d3 = this.mvt.modelToViewDeltaX(this.cuvette.location.getX());
        double d4 = this.mvt.modelToViewDeltaX(this.cuvette.width.get());
        this.paint.set(new GradientPaint((float)d3, 0.0f, color, (float)(d3 + d4), 0.0f, color2));
    }

    private void updateShape() {
        double d = this.light.location.getX();
        double d2 = this.light.getMinY();
        double d3 = this.detector.probeInBeam() ? this.detector.probe.getX() - d : 50.0;
        double d4 = this.light.lensDiameter;
        this.shape.set(new ImmutableRectangle2D(d, d2, d3, d4));
    }
}

