/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.BeersLawSolution;
import edu.colorado.phet.beerslawlab.beerslaw.model.Cuvette;
import edu.colorado.phet.beerslawlab.beerslaw.model.Light;
import edu.colorado.phet.common.phetcommon.model.property.ChangeObserver;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Absorbance {
    private final CompositeProperty<Double> molarAbsorptivity;
    private final CompositeProperty<Double> pathLength;
    private final Property<Double> concentration;
    public final CompositeProperty<Double> value;

    public Absorbance(final Light light, final Property<BeersLawSolution> property, final Cuvette cuvette) {
        this.molarAbsorptivity = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                return ((BeersLawSolution)property.get()).molarAbsorptivityData.wavelengthToMolarAbsorptivity(light.wavelength.get());
            }
        }, property, light.wavelength);
        this.pathLength = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                return cuvette.width.get();
            }
        }, cuvette.width);
        this.concentration = new Property<Double>(property.get().concentration.get());
        final VoidFunction1<Double> voidFunction1 = new VoidFunction1<Double>(){

            @Override
            public void apply(Double d) {
                Absorbance.this.concentration.set(d);
            }
        };
        property.get().concentration.addObserver(voidFunction1);
        property.addObserver(new ChangeObserver<BeersLawSolution>(){

            @Override
            public void update(BeersLawSolution beersLawSolution, BeersLawSolution beersLawSolution2) {
                beersLawSolution2.concentration.removeObserver(voidFunction1);
                beersLawSolution.concentration.addObserver(voidFunction1);
            }
        });
        this.value = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                return Absorbance.getAbsorbance((Double)Absorbance.this.molarAbsorptivity.get(), (Double)Absorbance.this.pathLength.get(), (Double)Absorbance.this.concentration.get());
            }
        }, this.molarAbsorptivity, this.pathLength, this.concentration);
    }

    public double getAbsorbanceAt(double d) {
        return Absorbance.getAbsorbance(this.molarAbsorptivity.get(), d, this.concentration.get());
    }

    public double getTransmittanceAt(double d) {
        return Absorbance.getTransmittance(this.getAbsorbanceAt(d));
    }

    public double getTransmittance() {
        return Absorbance.getTransmittance(this.value.get());
    }

    private static double getAbsorbance(double d, double d2, double d3) {
        return d * d2 * d3;
    }

    private static double getTransmittance(double d) {
        return Math.pow(10.0, -d);
    }
}

