/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.beerslawlab.beerslaw.model;

import edu.colorado.phet.beerslawlab.beerslaw.model.Absorbance;
import edu.colorado.phet.beerslawlab.beerslaw.model.Cuvette;
import edu.colorado.phet.beerslawlab.beerslaw.model.Light;
import edu.colorado.phet.beerslawlab.common.model.Movable;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.umd.cs.piccolo.util.PBounds;

public class ATDetector {
    private final Light light;
    private final Cuvette cuvette;
    private final Absorbance absorbance;
    public final CompositeProperty<Double> value;
    public final Movable body;
    public final Probe probe;
    public Property<ATDetectorMode> mode = new Property<ATDetectorMode>(ATDetectorMode.TRANSMITTANCE);

    public ATDetector(ImmutableVector2D immutableVector2D, PBounds pBounds, ImmutableVector2D immutableVector2D2, PBounds pBounds2, Light light, Cuvette cuvette, Absorbance absorbance) {
        this.light = light;
        this.cuvette = cuvette;
        this.absorbance = absorbance;
        this.body = new Movable(immutableVector2D, pBounds);
        this.probe = new Probe(immutableVector2D2, pBounds2, 0.57);
        this.value = new CompositeProperty<Double>(new Function0<Double>(){

            @Override
            public Double apply() {
                return ATDetector.this.computeValue();
            }
        }, this.probe.location, light.on, this.mode, absorbance.value);
    }

    public void reset() {
        this.body.reset();
        this.probe.reset();
        this.mode.reset();
    }

    private Double computeValue() {
        Double d = null;
        if (this.probeInBeam()) {
            double d2 = Math.min(Math.max(0.0, ((ImmutableVector2D)this.probe.location.get()).getX() - this.cuvette.location.getX()), this.cuvette.width.get());
            d = this.mode.get() == ATDetectorMode.ABSORBANCE ? Double.valueOf(this.absorbance.getAbsorbanceAt(d2)) : Double.valueOf(100.0 * this.absorbance.getTransmittanceAt(d2));
        }
        return d;
    }

    private double getProbeMinY() {
        return ((ImmutableVector2D)this.probe.location.get()).getY() - this.probe.sensorDiameter / 2.0;
    }

    private double getProbeMaxY() {
        return ((ImmutableVector2D)this.probe.location.get()).getY() + this.probe.sensorDiameter / 2.0;
    }

    public boolean probeInBeam() {
        return this.light.on.get() != false && this.getProbeMinY() < this.light.getMinY() && this.getProbeMaxY() > this.light.getMaxY() && ((ImmutableVector2D)this.probe.location.get()).getX() > this.light.location.getX();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ATDetectorMode
    extends Enum<ATDetectorMode> {
        public static final /* enum */ ATDetectorMode TRANSMITTANCE = new ATDetectorMode();
        public static final /* enum */ ATDetectorMode ABSORBANCE = new ATDetectorMode();
        private static final /* synthetic */ ATDetectorMode[] $VALUES;

        public static ATDetectorMode[] values() {
            return (ATDetectorMode[])$VALUES.clone();
        }

        static {
            $VALUES = new ATDetectorMode[]{TRANSMITTANCE, ABSORBANCE};
        }
    }

    public static class Probe
    extends Movable {
        public final double sensorDiameter;

        public Probe(ImmutableVector2D immutableVector2D, PBounds pBounds, double d) {
            super(immutableVector2D, pBounds);
            this.sensorDiameter = d;
        }
    }
}

