/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.phys2d.propagators;

import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.BoundsBounce;

public class EastBounce
extends BoundsBounce {
    double xMax;
    double distFromWall;

    public EastBounce(double d, double d2) {
        this.xMax = d;
        this.distFromWall = d2;
    }

    public boolean isOutOfBounds(DoublePoint doublePoint) {
        return doublePoint.getX() > this.xMax;
    }

    public DoublePoint getPointAtBounds(DoublePoint doublePoint) {
        return new DoublePoint(this.xMax, doublePoint.getY());
    }

    public DoublePoint getNewVelocity(DoublePoint doublePoint) {
        double d = -Math.abs(doublePoint.getX());
        return new DoublePoint(d - this.distFromWall, doublePoint.getY());
    }
}

