/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.phys2d;

import java.util.Vector;

public class DoublePoint {
    double x;
    double y;

    public DoublePoint() {
        this(0.0, 0.0);
    }

    public String toString() {
        Vector<Double> vector = new Vector<Double>();
        vector.add(new Double(this.x));
        vector.add(new Double(this.y));
        return vector.toString();
    }

    public double getLength() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public DoublePoint(double d, double d2) {
        this.x = d;
        this.y = d2;
        if (Double.isNaN(d)) {
            throw new RuntimeException("x was NaN");
        }
        if (Double.isNaN(d2)) {
            throw new RuntimeException("Y was NaN");
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public DoublePoint add(DoublePoint doublePoint) {
        return new DoublePoint(this.x + doublePoint.x, this.y + doublePoint.y);
    }

    public DoublePoint normalize() {
        double d = this.getLength();
        return this.multiply(1.0 / d);
    }

    public DoublePoint multiply(double d) {
        return new DoublePoint(this.x * d, this.y * d);
    }

    public double distance(DoublePoint doublePoint) {
        return Math.sqrt(Math.pow(doublePoint.x - this.x, 2.0) + Math.pow(doublePoint.y - this.y, 2.0));
    }

    public DoublePoint subtract(DoublePoint doublePoint) {
        return new DoublePoint(this.x - doublePoint.x, this.y - doublePoint.y);
    }
}

