/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.electron.paint.particle;

import edu.colorado.phet.batteryvoltage.common.electron.paint.particle.ParticlePainter;
import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryvoltage.common.phys2d.Particle;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class ImagePainter
implements ParticlePainter {
    BufferedImage im;

    public ImagePainter(BufferedImage bufferedImage) {
        this.im = bufferedImage;
    }

    public void paint(Particle particle, Graphics2D graphics2D) {
        DoublePoint doublePoint = particle.getPosition();
        int n = (int)doublePoint.getX() - this.im.getWidth() / 2;
        int n2 = (int)doublePoint.getY() - this.im.getHeight() / 2;
        graphics2D.drawRenderedImage(this.im, AffineTransform.getTranslateInstance(n, n2));
    }

    public boolean contains(Particle particle, Point point) {
        DoublePoint doublePoint = particle.getPosition();
        int n = (int)doublePoint.getX() - this.im.getWidth() / 2;
        int n2 = (int)doublePoint.getY() - this.im.getHeight() / 2;
        Rectangle rectangle = new Rectangle(n, n2, this.im.getWidth(), this.im.getHeight());
        return rectangle.contains(point.x, point.y);
    }
}

