/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.electron.man;

import edu.colorado.phet.batteryvoltage.common.electron.man.Man;
import edu.colorado.phet.batteryvoltage.common.electron.man.Node;
import edu.colorado.phet.batteryvoltage.common.electron.paint.Painter;
import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;

public class ManPainter
implements Painter {
    Man man;
    Stroke s;
    Color c;

    public ManPainter(Man man, Stroke stroke, Color color) {
        this.man = man;
        this.c = color;
        this.s = stroke;
    }

    public DoublePoint getHeadRoot() {
        DoublePoint doublePoint = this.man.getNeck().getPosition();
        return doublePoint.add(new DoublePoint(-this.man.getHeadWidth() / 2.0, -this.man.getHeadHeight()));
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(this.c);
        graphics2D.setStroke(this.s);
        DoublePoint doublePoint = this.man.getLeftEar().getPosition();
        DoublePoint doublePoint2 = this.man.getRightEar().getPosition();
        DoublePoint doublePoint3 = this.man.getHair().getPosition();
        DoublePoint doublePoint4 = this.getHeadRoot();
        graphics2D.drawOval((int)doublePoint4.getX(), (int)doublePoint4.getY(), (int)this.man.getHeadWidth(), (int)this.man.getHeadHeight());
        this.paint(graphics2D, this.man.getHip());
        this.paint(graphics2D, this.man.getLeftShoulder());
        this.paint(graphics2D, this.man.getRightShoulder());
        int n = (int)this.man.getNeck().getX();
        int n2 = (int)this.man.getNeck().getY();
        graphics2D.drawLine(n, n2, (int)this.man.getHip().getX(), (int)this.man.getHip().getY());
        graphics2D.drawLine(n, n2, (int)this.man.getLeftShoulder().getX(), (int)this.man.getLeftShoulder().getY());
        graphics2D.drawLine(n, n2, (int)this.man.getRightShoulder().getX(), (int)this.man.getRightShoulder().getY());
    }

    public void paint(Graphics2D graphics2D, Node node) {
        int n = (int)node.getX();
        int n2 = (int)node.getY();
        for (int i = 0; i < node.numChildren(); ++i) {
            int n3 = (int)node.childAt(i).getX();
            int n4 = (int)node.childAt(i).getY();
            graphics2D.drawLine(n, n2, n3, n4);
            this.paint(graphics2D, node.childAt(i));
        }
    }
}

