/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage.common.electron.components;

import edu.colorado.phet.batteryvoltage.BatteryVoltageResources;
import edu.colorado.phet.batteryvoltage.common.electron.components.IGauge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class Gauge
implements IGauge {
    int numMajorTicks;
    int numMinorTicks;
    double needleLength;
    double min;
    double max;
    double amount;
    int x;
    int y;
    int width;
    int height;
    String text = BatteryVoltageResources.getString("Gauge.DefaultText");

    public Gauge(int n, int n2, double d, double d2, double d3, double d4) {
        this(n, n2, (int)d4, (int)d4, d, d2, d3, d4 / 2.0, 5, 9);
    }

    public void setText(String string) {
        this.text = string;
    }

    public Gauge(int n, int n2, int n3, int n4, double d, double d2, double d3, double d4, int n5, int n6) {
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this.min = d;
        this.max = d2;
        this.amount = d3;
        this.needleLength = d4;
        this.numMajorTicks = n5;
        this.numMinorTicks = n6;
    }

    public void setValue(double d) {
        this.amount = d;
    }

    private Point getPoint(int n, double d) {
        int n2 = (int)((double)n * Math.sin(d) + (double)this.x + (double)(this.width / 2));
        int n3 = (int)((double)n * Math.cos(d) + (double)this.y + (double)(this.height / 2));
        return new Point(n2, n3);
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(this.x, this.y - 10, this.width, this.height / 2 + 20);
        this.drawText(graphics2D);
        this.drawNeedle(graphics2D);
        this.drawMinorTicks(graphics2D);
        this.drawTicks(graphics2D);
        this.drawArc(graphics2D);
        this.drawButton(graphics2D);
    }

    public void drawText(Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        graphics2D.setColor(Color.black);
        Point point = this.getPoint(10, 2.356194490192345);
        Rectangle2D rectangle2D = font.getStringBounds(this.text, graphics2D.getFontRenderContext());
        int n = (int)rectangle2D.getWidth();
        int n2 = this.x + this.width / 2 - n / 2;
        int n3 = this.y + this.height / 3;
        graphics2D.drawString(this.text, n2, n3);
    }

    public void drawButton(Graphics2D graphics2D) {
        graphics2D.setColor(Color.blue);
        Point point = this.getPoint(0, 0.0);
        int n = 5;
        graphics2D.fillRect(point.x - n, point.y - n, n * 2, n * 2);
    }

    protected double getBoundedValue() {
        double d = Math.min(this.amount, this.max);
        d = Math.max(d, this.min);
        return d;
    }

    public void drawNeedle(Graphics2D graphics2D) {
        double d = this.max - this.min;
        double d2 = this.getBoundedValue();
        double d3 = d2 / (this.max - this.min) * Math.PI;
        double d4 = this.needleLength * Math.sin(d3);
        double d5 = this.needleLength * Math.cos(d3);
        int n = this.x + this.width / 2;
        int n2 = this.y + this.height / 2;
        int n3 = n + (int)d4;
        int n4 = n2 - (int)d5;
        if (d2 == this.max || d2 == this.min) {
            graphics2D.setColor(Color.red);
        } else {
            graphics2D.setColor(new Color(200, 0, 180));
        }
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.drawLine(n, n2, n3, n4);
    }

    public void drawArc(Graphics2D graphics2D) {
        graphics2D.setStroke(new BasicStroke(5.0f));
        graphics2D.setColor(Color.black);
        graphics2D.drawArc(this.x, this.y, this.width, this.height, 0, 180);
        graphics2D.setColor(Color.blue);
        graphics2D.drawRect(this.x, this.y - 10, this.width, this.height / 2 + 20);
    }

    public void drawTicks(Graphics2D graphics2D) {
        Point point;
        Point point2;
        int n;
        graphics2D.setStroke(new BasicStroke(3.0f));
        double d = 1.5707963267948966 / (double)(this.numMajorTicks - 1);
        double d2 = Math.PI;
        graphics2D.setColor(Color.black);
        int n2 = 10;
        for (n = 0; n < this.numMajorTicks; ++n) {
            point2 = this.getPoint(this.width / 2 - n2, d2);
            point = this.getPoint(this.width / 2, d2);
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            d2 += d;
        }
        d2 = 1.5707963267948966;
        for (n = 0; n < this.numMajorTicks; ++n) {
            point2 = this.getPoint(this.width / 2 - n2, d2);
            point = this.getPoint(this.width / 2, d2);
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            d2 += d;
        }
    }

    public void drawMinorTicks(Graphics2D graphics2D) {
        Point point;
        Point point2;
        int n;
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d = 1.5707963267948966 / (double)(this.numMinorTicks - 1);
        double d2 = Math.PI;
        graphics2D.setColor(Color.green);
        int n2 = 7;
        for (n = 0; n < this.numMinorTicks; ++n) {
            point2 = this.getPoint(this.width / 2 - n2, d2);
            point = this.getPoint(this.width / 2, d2);
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            d2 += d;
        }
        d2 = 1.5707963267948966;
        for (n = 0; n < this.numMinorTicks; ++n) {
            point2 = this.getPoint(this.width / 2 - n2, d2);
            point = this.getPoint(this.width / 2, d2);
            graphics2D.drawLine(point2.x, point2.y, point.x, point.y);
            d2 += d;
        }
    }
}

