/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage;

import edu.colorado.phet.batteryvoltage.BatteryVoltageSimulationPanel;
import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;

public class BatteryVoltageApplication
extends PiccoloPhetApplication {
    public BatteryVoltageApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        BatteryVoltageModule batteryVoltageModule = new BatteryVoltageModule(phetApplicationConfig);
        this.addModule(batteryVoltageModule);
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new BatteryVoltageApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "battery-voltage");
        phetApplicationConfig.setFrameSetup(new FrameSetup.CenteredWithSize(850, 525));
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    private class BatteryVoltageModule
    extends Module {
        public BatteryVoltageModule(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig.getName(), new ConstantDtClock(20, 0.021));
            BatteryVoltageSimulationPanel batteryVoltageSimulationPanel = new BatteryVoltageSimulationPanel(this.getClock());
            this.setSimulationPanel(batteryVoltageSimulationPanel);
            this.setClockControlPanel(null);
            this.setLogoPanelVisible(false);
        }
    }
}

