/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.batteryvoltage;

import edu.colorado.phet.batteryvoltage.BatteryImagePainter;
import edu.colorado.phet.batteryvoltage.BatteryVoltageResources;
import edu.colorado.phet.batteryvoltage.GaugeUpdate;
import edu.colorado.phet.batteryvoltage.GuiToPaint;
import edu.colorado.phet.batteryvoltage.ImageChanger;
import edu.colorado.phet.batteryvoltage.MaxSpeed;
import edu.colorado.phet.batteryvoltage.ParticleMoveListener;
import edu.colorado.phet.batteryvoltage.ShowBattery;
import edu.colorado.phet.batteryvoltage.VoltParticleGrabber;
import edu.colorado.phet.batteryvoltage.WallPainter;
import edu.colorado.phet.batteryvoltage.common.electron.components.Gauge;
import edu.colorado.phet.batteryvoltage.common.electron.gui.Painter;
import edu.colorado.phet.batteryvoltage.common.electron.gui.mouse2.ParticleSelector;
import edu.colorado.phet.batteryvoltage.common.electron.laws.CoulombsLaw;
import edu.colorado.phet.batteryvoltage.common.electron.laws.ForceLawPropagator;
import edu.colorado.phet.batteryvoltage.common.electron.man.Man;
import edu.colorado.phet.batteryvoltage.common.electron.man.ManMaker;
import edu.colorado.phet.batteryvoltage.common.electron.man.ManPainter;
import edu.colorado.phet.batteryvoltage.common.electron.man.laws.ManLaw;
import edu.colorado.phet.batteryvoltage.common.electron.man.laws.ManMover;
import edu.colorado.phet.batteryvoltage.common.electron.man.laws.MotionChooser;
import edu.colorado.phet.batteryvoltage.common.electron.man.laws.ThoughtfulMover;
import edu.colorado.phet.batteryvoltage.common.electron.paint.ImageUtils;
import edu.colorado.phet.batteryvoltage.common.electron.paint.LayeredPanel;
import edu.colorado.phet.batteryvoltage.common.electron.paint.animate.AnimateLaw;
import edu.colorado.phet.batteryvoltage.common.electron.paint.animate.Movie;
import edu.colorado.phet.batteryvoltage.common.electron.paint.animate.ParticlePoint;
import edu.colorado.phet.batteryvoltage.common.electron.paint.animate.RotatingTwinkle2;
import edu.colorado.phet.batteryvoltage.common.electron.paint.particle.ImagePainter;
import edu.colorado.phet.batteryvoltage.common.electron.paint.particle.ParticlePainterAdapter;
import edu.colorado.phet.batteryvoltage.common.phys2d.CompositePropagator;
import edu.colorado.phet.batteryvoltage.common.phys2d.DoublePoint;
import edu.colorado.phet.batteryvoltage.common.phys2d.Particle;
import edu.colorado.phet.batteryvoltage.common.phys2d.ParticleLaw;
import edu.colorado.phet.batteryvoltage.common.phys2d.PropagatingParticle;
import edu.colorado.phet.batteryvoltage.common.phys2d.Propagator;
import edu.colorado.phet.batteryvoltage.common.phys2d.System2D;
import edu.colorado.phet.batteryvoltage.common.phys2d.laws.Repaint;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.FourBounds;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.NullPropagator;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.PositionUpdate;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.ResetAcceleration;
import edu.colorado.phet.batteryvoltage.common.phys2d.propagators.VelocityUpdate;
import edu.colorado.phet.batteryvoltage.man.Director;
import edu.colorado.phet.batteryvoltage.man.VoltMan;
import edu.colorado.phet.batteryvoltage.man.VoltManFactory;
import edu.colorado.phet.batteryvoltage.man.voltListeners.CompositeVoltageListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class Battery {
    Vector papas = new Vector();
    Vector moveListeners = new Vector();
    JPanel controlPanel = new JPanel();
    CompositePropagator leftPropagator;
    CompositePropagator rightPropagator;
    LayeredPanel panel;
    int height;
    System2D sys;
    Random r;
    int y;
    ForceLawPropagator cla;
    BufferedImage electronImage;
    BufferedImage leftPlusImage;
    BufferedImage rightPlusImage;
    Vector leftElectrons = new Vector();
    Vector rightElectrons = new Vector();

    public int numElectrons() {
        return this.numLeft() + this.numRight();
    }

    public int numLeft() {
        return this.leftElectrons.size();
    }

    public int numRight() {
        return this.rightElectrons.size();
    }

    public System2D getSystem() {
        return this.sys;
    }

    public Battery(int n, int n2, int n3, int n4, int n5, int n6, int n7, Random random, int n8, double d) {
        Object object;
        Object object2;
        Vector vector;
        Vector vector2;
        Object object3;
        int n9;
        int n10;
        this.r = random;
        this.y = n2;
        this.height = n4;
        this.panel = new LayeredPanel();
        this.sys = new System2D();
        this.sys.addLaw(new ParticleLaw());
        double d2 = 150000.0;
        double d3 = 5.0;
        double d4 = Double.MAX_VALUE;
        CoulombsLaw coulombsLaw = new CoulombsLaw(d4, d2, d3);
        this.cla = new ForceLawPropagator(coulombsLaw);
        FourBounds fourBounds = new FourBounds(n, n2, n5, n4, 1.2);
        int n11 = n + n3;
        FourBounds fourBounds2 = new FourBounds(n5 + n6, n2, n + n3 - n5 - n6, n4, 1.2);
        double d5 = 225.0;
        this.leftPropagator = new CompositePropagator();
        this.leftPropagator.add(new ResetAcceleration());
        this.leftPropagator.add(this.cla);
        this.leftPropagator.add(fourBounds);
        VelocityUpdate velocityUpdate = new VelocityUpdate(d5);
        this.leftPropagator.add(velocityUpdate);
        this.leftPropagator.add(new PositionUpdate());
        this.rightPropagator = new CompositePropagator();
        this.rightPropagator.add(new ResetAcceleration());
        this.rightPropagator.add(this.cla);
        this.rightPropagator.add(fourBounds2);
        VelocityUpdate velocityUpdate2 = new VelocityUpdate(d5);
        this.rightPropagator.add(velocityUpdate2);
        this.rightPropagator.add(new PositionUpdate());
        this.sys.addLaw(new Repaint(this.panel));
        this.electronImage = BatteryVoltageResources.getImage("electron9.gif");
        this.electronImage = ImageUtils.scale(this.electronImage, 0.45);
        this.rightPlusImage = BatteryVoltageResources.getImage("components/batteries/AA-battery-600.gif");
        this.leftPlusImage = BatteryVoltageResources.getImage("components/batteries/AA-battery-600-left.gif");
        this.rightPlusImage = ImageUtils.scaleToSizeApproximate(this.rightPlusImage, n3 + 60, n4 + 35);
        this.leftPlusImage = ImageUtils.scaleToSizeApproximate(this.leftPlusImage, n3 + 60, n4 + 35);
        WallPainter wallPainter = new WallPainter(fourBounds.toRectangle(), 10);
        this.panel.addPainter(wallPainter);
        wallPainter = new WallPainter(fourBounds2.toRectangle(), 10);
        this.panel.addPainter(wallPainter);
        BatteryImagePainter batteryImagePainter = new BatteryImagePainter(this.leftPlusImage);
        this.panel.addPainter(batteryImagePainter);
        ImageChanger imageChanger = new ImageChanger(batteryImagePainter, this.leftPlusImage, this.rightPlusImage, n7);
        Movie movie = new Movie();
        for (n10 = 0; n10 < n7 / 2; ++n10) {
            this.addParticle(n, n5, this.leftPropagator, this.leftElectrons, movie);
        }
        for (n10 = n7 / 2; n10 < n7; ++n10) {
            this.addParticle(n5 + n6, n + n3 - n5 - n6, this.rightPropagator, this.rightElectrons, movie);
        }
        double d6 = 12.0;
        ManLaw manLaw = new ManLaw(d6);
        this.sys.addLaw(manLaw);
        double d7 = 0.17;
        Vector vector3 = new Vector();
        double d8 = n5 + n6 / 2;
        double d9 = 10.0;
        double d10 = 16.0;
        double d11 = 2.0;
        double d12 = d10 * 1.2;
        double d13 = 10.0;
        Hashtable hashtable = new Hashtable();
        double d14 = d10;
        double d15 = 10.0;
        int n12 = 10;
        Vector vector4 = new Vector();
        VoltManFactory voltManFactory = new VoltManFactory(n5, n6, d10, this.leftPropagator, this.rightPropagator, n12, hashtable, d14, vector3, d15, d11, d12, vector4, this);
        Color[] colorArray = new Color[]{Color.red, Color.blue, Color.green, Color.gray, Color.orange, Color.yellow, new Color(200, 20, 200), Color.white};
        JSlider jSlider = new JSlider(0, n7, n7 / 2);
        jSlider.setPreferredSize(new Dimension(275, 50));
        jSlider.setMajorTickSpacing(4);
        jSlider.setMinorTickSpacing(2);
        jSlider.setPaintTicks(true);
        CompositeVoltageListener compositeVoltageListener = new CompositeVoltageListener(jSlider, this);
        jSlider.setBorder(BorderFactory.createTitledBorder(BatteryVoltageResources.getString("Battery.VoltageSlider")));
        jSlider.addChangeListener(compositeVoltageListener);
        this.controlPanel.setLayout(new FlowLayout());
        JCheckBox jCheckBox = new JCheckBox(BatteryVoltageResources.getString("Battery.ShowBatteryCheckBox"));
        jCheckBox.addItemListener(new ShowBattery(jCheckBox, batteryImagePainter));
        this.controlPanel.add(jCheckBox);
        this.controlPanel.add(jSlider);
        int n13 = 5;
        int n14 = n2 + n13;
        int n15 = n4 - 2 * n13;
        int n16 = n15 / n8;
        Director director = new Director(this.sys, vector3, vector4, 0, d8);
        this.addParticleMoveListener(director);
        compositeVoltageListener.addVoltageListener(director);
        compositeVoltageListener.addVoltageListener(imageChanger);
        this.addParticleMoveListener(new MaxSpeed(velocityUpdate, velocityUpdate2));
        for (n9 = 0; n9 < n8; ++n9) {
            Man man = new ManMaker(d7).newMan();
            DoublePoint doublePoint = new DoublePoint(d8, n14 + n9 * n16);
            object3 = doublePoint.subtract(man.getNeck().getPosition());
            man.getNeck().translate(((DoublePoint)object3).getX(), ((DoublePoint)object3).getY());
            vector2 = voltManFactory.newMan(man, doublePoint);
            director.addVoltMan((VoltMan)((Object)vector2));
            vector = vector2;
            object2 = new ThoughtfulMover(man, (MotionChooser)((Object)vector));
            manLaw.add((ManMover)object2);
            object = colorArray[n9 % colorArray.length];
            this.panel.addPainter(new ManPainter(man, new BasicStroke(2.0f), (Color)object));
        }
        n9 = n + n3 + 60;
        int n17 = 200;
        int n18 = 250;
        object3 = new Gauge(n9, n17, -n7, n7, 0.0, n18);
        vector2 = new GaugeUpdate((Gauge)object3, this.sys, this.rightPropagator, this.leftPropagator);
        this.addParticleMoveListener((ParticleMoveListener)((Object)vector2));
        ((Gauge)object3).setText(BatteryVoltageResources.getString("Battery.GaugeText"));
        this.panel.addPainter(new GuiToPaint((Painter)object3));
        vector = new Vector();
        vector.addAll(this.leftElectrons);
        vector.addAll(this.rightElectrons);
        director.initTags(vector.toArray(new Particle[0]));
        compositeVoltageListener.stateChanged(null);
        this.fireParticleMoved(null);
        object2 = new ParticleSelector();
        ((ParticleSelector)object2).addAll(this.papas.toArray(new ParticlePainterAdapter[0]));
        object = new VoltParticleGrabber(this.panel, (ParticleSelector)object2, new NullPropagator(), this.rightPropagator, this.leftPropagator, n + n3 / 2, this, director);
        this.panel.addMouseMotionListener((MouseMotionListener)object);
        this.panel.addMouseListener((MouseListener)object);
        int n19 = 100;
        AnimateLaw animateLaw = new AnimateLaw(d * 2.5, movie, this.panel, n19);
        new Thread(new AnimateAdder(1200, animateLaw, this.sys, this.panel, n19)).start();
        animateLaw = new AnimateLaw(d * 2.5, movie, this.panel, n19);
        new Thread(new AnimateAdder(5000, animateLaw, this.sys, this.panel, n19)).start();
        animateLaw = new AnimateLaw(d * 2.5, movie, this.panel, n19);
        new Thread(new AnimateAdder(10000, animateLaw, this.sys, this.panel, n19)).start();
    }

    public void addParticleMoveListener(ParticleMoveListener particleMoveListener) {
        this.moveListeners.add(particleMoveListener);
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public void setLeft(Particle particle) {
        this.rightElectrons.remove(particle);
        if (!this.leftElectrons.contains(particle)) {
            this.leftElectrons.add(particle);
        }
        this.fireParticleMoved(particle);
    }

    public void setRight(Particle particle) {
        this.leftElectrons.remove(particle);
        if (!this.rightElectrons.contains(particle)) {
            this.rightElectrons.add(particle);
        }
        this.fireParticleMoved(particle);
    }

    void fireParticleMoved(Particle particle) {
        for (int i = 0; i < this.moveListeners.size(); ++i) {
            ParticleMoveListener particleMoveListener = (ParticleMoveListener)this.moveListeners.get(i);
            particleMoveListener.particleMoved(this, particle);
        }
    }

    public void addParticle(int n, int n2, Propagator propagator, Vector vector, Movie movie) {
        PropagatingParticle propagatingParticle = new PropagatingParticle(propagator);
        vector.add(propagatingParticle);
        int n3 = this.r.nextInt(n2) + n;
        int n4 = this.r.nextInt(this.height) + this.y;
        propagatingParticle.setVelocity(new DoublePoint(0.0, 0.0));
        propagatingParticle.setPosition(new DoublePoint(n3, n4));
        ParticlePainterAdapter particlePainterAdapter = new ParticlePainterAdapter(new ImagePainter(this.electronImage), propagatingParticle);
        this.panel.addPainter(particlePainterAdapter);
        this.papas.add(particlePainterAdapter);
        this.cla.add(propagatingParticle);
        propagatingParticle.setCharge(-1.0);
        this.sys.addParticle(propagatingParticle);
        BasicStroke basicStroke = new BasicStroke(0.8f);
        RotatingTwinkle2 rotatingTwinkle2 = new RotatingTwinkle2(new ParticlePoint(propagatingParticle), basicStroke, 20, 3.0, 8.0, 15.0);
        movie.addAnimation(rotatingTwinkle2);
    }

    public JPanel getJPanel() {
        return this.panel;
    }

    public static class AnimateAdder
    implements Runnable {
        int waitTime;
        AnimateLaw al;
        System2D sys;
        LayeredPanel p;
        int layer;

        public AnimateAdder(int n, AnimateLaw animateLaw, System2D system2D, LayeredPanel layeredPanel, int n2) {
            this.waitTime = n;
            this.al = animateLaw;
            this.sys = system2D;
            this.p = layeredPanel;
            this.layer = n2;
        }

        public void run() {
            try {
                Thread.sleep(this.waitTime);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            this.sys.addLaw(this.al);
            this.p.addPainter(this.al, this.layer);
        }
    }
}

