/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonDragListener;
import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.common.phetcommon.math.DoubleSeries;
import java.awt.Point;
import java.util.Vector;

public class ThresholdFilter
implements BalloonDragListener {
    DoubleSeries x;
    DoubleSeries y;
    long lastSampleTime = -1L;
    Point lastPos;
    double thresh;
    Vector list = new Vector();

    public void addBalloonDragListener(BalloonDragListener balloonDragListener) {
        this.list.add(balloonDragListener);
    }

    public ThresholdFilter(int n, int n2, double d) {
        this.x = new DoubleSeries(n);
        this.y = new DoubleSeries(n2);
        this.thresh = d;
    }

    public void balloonDragged(BalloonPainter balloonPainter) {
        Point point = balloonPainter.getPosition();
        if (this.lastSampleTime == -1L || this.lastPos == null) {
            this.lastSampleTime = System.currentTimeMillis();
            this.lastPos = point;
            return;
        }
        Point point2 = new Point(point.x - this.lastPos.x, point.y - this.lastPos.y);
        long l = System.currentTimeMillis();
        long l2 = l - this.lastSampleTime;
        if (l2 > 0L) {
            double d = (double)point2.x / (double)l2;
            double d2 = (double)point2.y / (double)l2;
            this.x.add(d * d);
            this.y.add(d2 * d2);
            double d3 = this.x.average();
            double d4 = this.y.average();
            double d5 = Math.sqrt(d3 + d4);
            this.lastSampleTime = l;
            if (d5 >= this.thresh) {
                for (int i = 0; i < this.list.size(); ++i) {
                    ((BalloonDragListener)this.list.get(i)).balloonDragged(balloonPainter);
                }
            }
        }
        this.lastPos = point;
    }
}

