/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.Charge;
import edu.colorado.phet.balloons.common.paint.ParticlePainter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.Particle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class PlusPainter
implements ParticlePainter {
    int halfWidth;
    int width;
    Color c;
    int strokeWidth;
    int halfStroke;
    int paint;

    public void setPaint(int n) {
        this.paint = n;
    }

    public PlusPainter(int n, int n2, Color color) {
        this.strokeWidth = n2;
        this.width = n;
        this.c = color;
        this.halfWidth = n / 2;
        this.halfStroke = n2 / 2;
    }

    boolean ok(Charge charge) {
        return !charge.addsToNeutral();
    }

    public void paintAt(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setColor(this.c);
        Point point = new Point(n - this.halfStroke, n2 - this.halfWidth);
        Point point2 = new Point(n - this.halfWidth, n2 - this.halfStroke);
        graphics2D.fillRect(point.x, point.y, this.strokeWidth, this.width);
        graphics2D.fillRect(point2.x, point2.y, this.width, this.strokeWidth);
    }

    public void paint(Charge charge, int n, int n2, Graphics2D graphics2D) {
        if (this.paint == 1) {
            return;
        }
        if (this.paint == 0 || this.paint == 2 && this.ok(charge)) {
            this.paintAt(n, n2, graphics2D);
        }
    }

    public void paint(Particle particle, Graphics2D graphics2D) {
        DoublePoint doublePoint = particle.getPosition();
        int n = (int)doublePoint.getX();
        int n2 = (int)doublePoint.getY();
        this.paint((Charge)particle, n, n2, graphics2D);
    }
}

