/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.balloons.Charge;
import edu.colorado.phet.balloons.MinusPainter;
import edu.colorado.phet.balloons.Stick;
import edu.colorado.phet.balloons.common.paint.LayeredPainter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.NullPropagator;
import edu.colorado.phet.balloons.common.phys2d.Particle;
import edu.colorado.phet.balloons.common.phys2d.Propagator;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class MoveToBalloon
implements Propagator {
    BalloonPainter ip;
    double v;
    LayeredPainter lp;
    MinusPainter mp;

    public MoveToBalloon(double d, LayeredPainter layeredPainter, MinusPainter minusPainter) {
        this.mp = minusPainter;
        this.v = d;
        this.lp = layeredPainter;
    }

    public void setTarget(BalloonPainter balloonPainter) {
        this.ip = balloonPainter;
    }

    public void propagate(double d, Particle particle) {
        Point point = this.ip.getPosition();
        BufferedImage bufferedImage = this.ip.getImage();
        DoublePoint doublePoint = new DoublePoint(point.x + bufferedImage.getWidth() / 2, point.y + bufferedImage.getHeight() / 2);
        DoublePoint doublePoint2 = doublePoint.subtract(particle.getPosition()).normalize().multiply(this.v * d);
        DoublePoint doublePoint3 = doublePoint2.add(particle.getPosition());
        particle.setPosition(doublePoint3);
        double d2 = 60.0;
        if (doublePoint3.distance(doublePoint) < d2) {
            Point point2 = new Point((int)doublePoint3.getX(), (int)doublePoint3.getY());
            Point point3 = this.ip.getPosition();
            Point point4 = new Point(point2.x - point3.x, point2.y - point3.y);
            Charge charge = (Charge)particle;
            charge.setPropagator(new NullPropagator());
            Stick stick = new Stick(this.ip, point4, charge, this.mp);
            this.lp.removePainter(charge.getPainter(), charge.getLevel());
            charge.setPainter(charge.getPainter(), 1);
            this.ip.addPainter(stick, charge);
        }
    }
}

