/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.Charge;
import edu.colorado.phet.balloons.common.paint.ParticlePainter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.Particle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;

public class MinusPainter
implements ParticlePainter {
    int halfWidth;
    int width;
    Color color;
    int strokeWidth;
    int halfStroke;
    int paint;

    public MinusPainter(int n, int n2, Color color) {
        this.strokeWidth = n2;
        this.width = n;
        this.color = color;
        this.halfWidth = n / 2;
        this.halfStroke = n2 / 2;
    }

    public void setPaint(int n) {
        this.paint = n;
    }

    public boolean ok(Charge charge) {
        return !charge.addsToNeutral();
    }

    public void paint(Charge charge, int n, int n2, Graphics2D graphics2D) {
        if (this.paint == 1) {
            return;
        }
        if (this.paint == 0 || this.paint == 2 && this.ok(charge)) {
            this.paintAt(n, n2, graphics2D);
        }
    }

    public void paintAt(int n, int n2, Graphics2D graphics2D) {
        graphics2D.setColor(this.color);
        Point point = new Point(n - this.halfWidth, n2 - this.halfStroke);
        graphics2D.fillRect(point.x, point.y, this.width, this.strokeWidth);
    }

    public void paint(Particle particle, Graphics2D graphics2D) {
        DoublePoint doublePoint = particle.getPosition();
        int n = (int)doublePoint.getX();
        int n2 = (int)doublePoint.getY();
        this.paint((Charge)particle, n, n2, graphics2D);
    }
}

