/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonDragger;
import edu.colorado.phet.balloons.BalloonForces;
import edu.colorado.phet.balloons.BalloonHelpPainter;
import edu.colorado.phet.balloons.BalloonImage;
import edu.colorado.phet.balloons.BalloonPainter;
import edu.colorado.phet.balloons.BalloonsApplication;
import edu.colorado.phet.balloons.BalloonsResources;
import edu.colorado.phet.balloons.Charge;
import edu.colorado.phet.balloons.ChargeMover;
import edu.colorado.phet.balloons.MinusPainter;
import edu.colorado.phet.balloons.MoveToBalloon;
import edu.colorado.phet.balloons.PlusPainter;
import edu.colorado.phet.balloons.Reset;
import edu.colorado.phet.balloons.SetBalloonCharge;
import edu.colorado.phet.balloons.ShowAll;
import edu.colorado.phet.balloons.ShowDiff;
import edu.colorado.phet.balloons.ShowNone;
import edu.colorado.phet.balloons.Sweater;
import edu.colorado.phet.balloons.ThresholdFilter;
import edu.colorado.phet.balloons.TwoBalloonsHandler;
import edu.colorado.phet.balloons.Wall;
import edu.colorado.phet.balloons.common.paint.DoubleBufferPainter;
import edu.colorado.phet.balloons.common.paint.FilledRectanglePainter;
import edu.colorado.phet.balloons.common.paint.FixedImagePainter;
import edu.colorado.phet.balloons.common.paint.LayeredPainter;
import edu.colorado.phet.balloons.common.paint.Painter;
import edu.colorado.phet.balloons.common.paint.PainterPanel;
import edu.colorado.phet.balloons.common.paint.ParticlePainterAdapter;
import edu.colorado.phet.balloons.common.phys2d.DoublePoint;
import edu.colorado.phet.balloons.common.phys2d.ParticleLaw;
import edu.colorado.phet.balloons.common.phys2d.Repaint;
import edu.colorado.phet.balloons.common.phys2d.System2D;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.view.HelpPanel;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Random;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class BalloonsSimulationPanel
extends JPanel {
    private PainterPanel painterPanel;
    private LayeredPainter layeredPainter;
    private boolean miniHelpShowing = false;
    private Painter balloonHelp;
    private BufferedImage sweaterImage;
    private int wallWidth;
    private JPanel controlPanel;
    private Wall wall;
    static Color plusColor = new Color(255, 0, 0);
    static Color minusColor = new Color(0, 0, 255);
    static PlusPainter plusPainter = new PlusPainter(14, 4, plusColor);
    static MinusPainter minusPainter = new MinusPainter(14, 4, minusColor);

    public static void paintCharge(BufferedImage bufferedImage) {
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        plusPainter.paintAt(40, 60, graphics2D);
        plusPainter.paintAt(90, 50, graphics2D);
        plusPainter.paintAt(98, 80, graphics2D);
        plusPainter.paintAt(90, 150, graphics2D);
        minusPainter.paintAt(80, 110, graphics2D);
        plusPainter.paintAt(30, 75, graphics2D);
        minusPainter.paintAt(78, 120, graphics2D);
        minusPainter.paintAt(50, 98, graphics2D);
        minusPainter.paintAt(40, 40, graphics2D);
        minusPainter.paintAt(30, 170, graphics2D);
        plusPainter.paintAt(40, 90, graphics2D);
        minusPainter.paintAt(55, 80, graphics2D);
        plusPainter.paintAt(30, 175, graphics2D);
        plusPainter.paintAt(94, 180, graphics2D);
        minusPainter.paintAt(45, 40, graphics2D);
        plusPainter.paintAt(50, 30, graphics2D);
        minusPainter.paintAt(72, 62, graphics2D);
        minusPainter.paintAt(50, 95, graphics2D);
        plusPainter.paintAt(50, 130, graphics2D);
        minusPainter.paintAt(54, 110, graphics2D);
        plusPainter.paintAt(90, 150, graphics2D);
        minusPainter.paintAt(50, 175, graphics2D);
        minusPainter.paintAt(84, 167, graphics2D);
    }

    public void init(BalloonsApplication.BalloonsModule balloonsModule) throws IOException {
        int n;
        Object object;
        plusPainter.setPaint(1);
        minusPainter.setPaint(1);
        int n2 = 750;
        int n3 = 500;
        String string = "balloon-blue.gif";
        String string2 = "balloon-yellow.gif";
        BufferedImage bufferedImage = BufferedImageUtils.copyImage(BalloonsResources.getImage("" + string), 2);
        BufferedImage bufferedImage2 = BalloonsResources.getImage("" + string);
        BufferedImage bufferedImage3 = BufferedImageUtils.copyImage(BalloonsResources.getImage("" + string2), 2);
        BufferedImage bufferedImage4 = BalloonsResources.getImage("" + string2);
        BalloonsSimulationPanel.paintCharge(bufferedImage4);
        BalloonsSimulationPanel.paintCharge(bufferedImage2);
        Point point = new Point(400, 10);
        BalloonImage balloonImage = new BalloonImage(point.x, point.y, bufferedImage, bufferedImage2);
        Point point2 = new Point(59, 233);
        Point point3 = new Point(430 + bufferedImage3.getWidth() / 2, 600);
        int n4 = 300;
        BasicStroke basicStroke = new BasicStroke(2.2f);
        Color color = new Color(200, 10, 230, 160);
        BalloonPainter balloonPainter = new BalloonPainter(balloonImage, point2, point3, basicStroke, color);
        balloonPainter.setInitialPosition(point);
        balloonPainter.setVisible(false);
        Point point4 = new Point(480, 18);
        BalloonImage balloonImage2 = new BalloonImage(point4.x, point4.y, bufferedImage3, bufferedImage4);
        BalloonPainter balloonPainter2 = new BalloonPainter(balloonImage2, point2, point3, basicStroke, color);
        balloonPainter2.setInitialPosition(point4);
        this.layeredPainter = new LayeredPainter();
        Reset reset = new Reset(this, this.layeredPainter);
        reset.addBalloonPainter(balloonPainter2);
        reset.addBalloonPainter(balloonPainter);
        this.layeredPainter.addPainter(new FilledRectanglePainter(n2, n3, new Color(240, 240, 255)), -1);
        DoubleBufferPainter doubleBufferPainter = new DoubleBufferPainter(this.layeredPainter, n2, n3);
        this.painterPanel = new PainterPanel(doubleBufferPainter);
        this.wallWidth = 80;
        int n5 = 10;
        JCheckBox jCheckBox = new JCheckBox(BalloonsResources.getString("BalloonApplet.Wall"), true);
        Rectangle rectangle = new Rectangle(750 - this.wallWidth, 0, this.wallWidth, 500);
        Rectangle rectangle2 = new Rectangle(750 - this.wallWidth + n5, 0, this.wallWidth - n5 * 2, 500);
        FilledRectanglePainter filledRectanglePainter = new FilledRectanglePainter(rectangle.x, rectangle.y, rectangle.width, rectangle.height, Color.yellow);
        Random random = new Random();
        this.wall = new Wall(jCheckBox, rectangle2, filledRectanglePainter, plusPainter, minusPainter, balloonPainter, balloonPainter2);
        Rectangle rectangle3 = new Rectangle(0, 0, 750 - bufferedImage.getWidth() - this.wallWidth, 500 - bufferedImage.getHeight() - 55);
        BalloonDragger balloonDragger = new BalloonDragger(new BalloonPainter[]{balloonPainter, balloonPainter2}, this.painterPanel, rectangle3, this.wall);
        this.painterPanel.addMouseListener(balloonDragger);
        this.painterPanel.addMouseMotionListener(balloonDragger);
        double d = 0.38;
        ThresholdFilter thresholdFilter = new ThresholdFilter(5, 5, d);
        int n6 = 15;
        MoveToBalloon moveToBalloon = new MoveToBalloon(n6, this.layeredPainter, minusPainter);
        ChargeMover chargeMover = new ChargeMover(moveToBalloon, this.layeredPainter);
        reset.setChargeMover(chargeMover);
        thresholdFilter.addBalloonDragListener(chargeMover);
        balloonDragger.addBalloonDragListener(thresholdFilter);
        this.sweaterImage = BalloonsResources.getImage("sweaterWidth300.gif");
        FixedImagePainter fixedImagePainter = new FixedImagePainter(this.sweaterImage);
        this.layeredPainter.addPainter(fixedImagePainter, 0);
        this.layeredPainter.addPainter(balloonDragger, 2);
        this.controlPanel = new JPanel();
        this.controlPanel.setLayout(new BoxLayout(this.controlPanel, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.painterPanel, "Center");
        jPanel.add((Component)this.controlPanel, "South");
        JCheckBox jCheckBox2 = new JCheckBox(BalloonsResources.getString("BalloonApplet.IgnoreInitialBalloonCharge"), true);
        JRadioButton jRadioButton = new JRadioButton(BalloonsResources.getString("BalloonApplet.ShowAllCharges"));
        jRadioButton.addActionListener(new ShowAll(plusPainter, minusPainter));
        JRadioButton jRadioButton2 = new JRadioButton(BalloonsResources.getString("BalloonApplet.ShowNoCharges"));
        jRadioButton2.addActionListener(new ShowNone(plusPainter, minusPainter));
        JRadioButton jRadioButton3 = new JRadioButton(BalloonsResources.getString("BalloonApplet.ShowChargeDifferences"));
        jRadioButton3.addActionListener(new ShowDiff(plusPainter, minusPainter));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        jRadioButton.setSelected(true);
        ActionListener[] actionListenerArray = jRadioButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            object = actionListenerArray[i];
            object.actionPerformed(new ActionEvent(jRadioButton, (int)System.currentTimeMillis(), "fire"));
        }
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jRadioButton);
        jPanel2.add(jRadioButton2);
        jPanel2.add(jRadioButton3);
        jPanel2.setBorder(BalloonsSimulationPanel.createSmoothBorder(BalloonsResources.getString("BalloonApplet.ChargeDisplay")));
        object = new JButton(PhetCommonResources.getString("Common.StopwatchPanel.reset"));
        this.controlPanel.add((Component)object);
        this.controlPanel.add(jPanel2);
        JCheckBox jCheckBox3 = new JCheckBox(BalloonsResources.getString("BalloonApplet.TwoBalloons"), false);
        jCheckBox3.addActionListener(new TwoBalloonsHandler(jCheckBox3, balloonPainter));
        SetBalloonCharge setBalloonCharge = new SetBalloonCharge(jCheckBox2, balloonImage, jRadioButton);
        jCheckBox2.addActionListener(setBalloonCharge);
        SetBalloonCharge setBalloonCharge2 = new SetBalloonCharge(jCheckBox2, balloonImage2, jRadioButton);
        jCheckBox2.addActionListener(setBalloonCharge2);
        jRadioButton.addActionListener(setBalloonCharge);
        jRadioButton.addActionListener(setBalloonCharge2);
        jRadioButton3.addActionListener(setBalloonCharge);
        jRadioButton3.addActionListener(setBalloonCharge2);
        jRadioButton2.addActionListener(setBalloonCharge);
        jRadioButton2.addActionListener(setBalloonCharge2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jCheckBox3);
        jPanel3.add(jCheckBox2);
        this.controlPanel.add(jPanel3);
        this.controlPanel.add(jCheckBox);
        HelpPanel helpPanel = new HelpPanel(balloonsModule);
        this.controlPanel.add(helpPanel);
        this.layeredPainter.addPainter(this.wall, 10);
        int n7 = 100;
        int n8 = 70;
        int n9 = this.sweaterImage.getWidth() - 55;
        int n10 = 90;
        int n11 = this.sweaterImage.getHeight() - 80;
        final System2D system2D = new System2D();
        Sweater sweater = new Sweater(new DoublePoint(this.sweaterImage.getWidth() / 2, this.sweaterImage.getHeight() / 2));
        ((AbstractButton)object).addActionListener(reset);
        int n12 = 20;
        int n13 = 20;
        for (n = 0; n < n7; ++n) {
            Charge charge = new Charge();
            int n14 = random.nextInt(n9 - n8) + n8;
            int n15 = random.nextInt(n11 - n10) + n10;
            int n16 = random.nextInt(2 * n12) - n12;
            int n17 = random.nextInt(2 * n13) - n13;
            charge.setPosition(new DoublePoint(n14 + n16, n15 + n17));
            charge.setInitialPosition(new DoublePoint(n14 + n16, n15 + n17));
            charge.setMass(1.0);
            charge.setCharge(1.0);
            Charge charge2 = new Charge();
            charge2.setPosition(new DoublePoint(n14, n15));
            charge2.setInitialPosition(new DoublePoint(n14, n15));
            charge2.setMass(1.0);
            charge2.setCharge(-1.0);
            charge2.setPartner(charge);
            system2D.addParticle(charge2);
            chargeMover.addParticle(charge2);
            ParticlePainterAdapter particlePainterAdapter = new ParticlePainterAdapter(plusPainter, charge);
            this.layeredPainter.addPainter(particlePainterAdapter, 1);
            ParticlePainterAdapter particlePainterAdapter2 = new ParticlePainterAdapter(minusPainter, charge2);
            this.layeredPainter.addPainter(particlePainterAdapter2, 1);
            charge.setPainter(particlePainterAdapter, 1);
            charge2.setPainter(particlePainterAdapter2, 1);
            reset.addCharge(charge);
            reset.addCharge(charge2);
        }
        system2D.addLaw(new ParticleLaw());
        n = rectangle3.x + rectangle3.width;
        int n18 = n - this.sweaterImage.getWidth() / 2;
        Rectangle rectangle4 = new Rectangle(this.sweaterImage.getWidth() / 2, 0, n18 + 143, 450);
        system2D.addLaw(new BalloonForces(balloonPainter, balloonPainter2, sweater, rectangle4, rectangle.x, this.wall));
        system2D.addLaw(this.wall);
        system2D.addLaw(new Repaint(this.painterPanel));
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "Center");
        balloonsModule.getClock().addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                system2D.iterate(clockEvent.getSimulationTimeChange());
            }
        });
        this.validate();
        this.painterPanel.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                system2D.iterate(1.2);
                BalloonsSimulationPanel.this.painterPanel.repaint();
            }
        });
        this.balloonHelp = new BalloonHelpPainter(this);
    }

    public void setHelpEnabled(boolean bl) {
        if (this.miniHelpShowing != bl) {
            this.miniHelpShowing = bl;
            int n = 100;
            if (bl) {
                this.layeredPainter.addPainter(this.balloonHelp, n);
            } else {
                this.layeredPainter.removePainter(this.balloonHelp, n);
            }
            this.repaintAll();
        }
    }

    private void repaintAll() {
    }

    public float getSweaterMaxX() {
        return this.sweaterImage.getWidth();
    }

    public int getWallX() {
        return this.getWidth() - this.wallWidth;
    }

    public int getWallHeight() {
        return this.painterPanel.getHeight();
    }

    public static Border createSmoothBorder(String string) {
        return new TitledBorder(string){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        };
    }

    public int getControlPanelHeight() {
        if (this.controlPanel == null) {
            return 0;
        }
        return this.controlPanel.getPreferredSize().height;
    }
}

