/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balloons;

import edu.colorado.phet.balloons.BalloonsSimulationPanel;
import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import java.awt.Color;
import java.awt.HeadlessException;
import java.io.IOException;
import javax.swing.JFrame;

public class BalloonsApplication
extends PiccoloPhetApplication {
    private BalloonsModule module;
    public static final double DT = 1.2;

    public BalloonsApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        this.module = new BalloonsModule(phetApplicationConfig);
        this.addModule(this.module);
        new BalloonsFrameSetup().initialize(this.getPhetFrame());
    }

    protected PhetFrame createPhetFrame() {
        return new BalloonsFrame(this);
    }

    private int getControlPanelHeight() {
        if (this.module == null) {
            return 0;
        }
        return this.module.getControlPanelHeight();
    }

    public static void main(String[] stringArray) {
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "balloons");
        phetApplicationConfig.getLookAndFeel().setBackgroundColor(new Color(200, 240, 200));
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new BalloonsApplication(phetApplicationConfig);
            }
        });
    }

    static class BalloonsFrame
    extends PhetFrame {
        private BalloonsApplication application;

        public BalloonsFrame(BalloonsApplication balloonsApplication) throws HeadlessException {
            super(balloonsApplication);
            this.application = balloonsApplication;
        }

        public int getControlPanelHeight() {
            return this.application.getControlPanelHeight();
        }
    }

    public static class BalloonsFrameSetup
    implements FrameSetup {
        public void initialize(JFrame jFrame) {
            BalloonsFrame balloonsFrame = (BalloonsFrame)jFrame;
            jFrame.setSize(750, 500 + balloonsFrame.getControlPanelHeight() + 10);
            jFrame.setResizable(false);
            SwingUtils.centerWindowOnScreen(jFrame);
        }
    }

    public class BalloonsModule
    extends Module {
        private BalloonsSimulationPanel balloonsSimulationPanel;

        public BalloonsModule(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig.getName(), new ConstantDtClock(30, 1.2));
            this.balloonsSimulationPanel = new BalloonsSimulationPanel();
            try {
                this.balloonsSimulationPanel.init(this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setSimulationPanel(this.balloonsSimulationPanel);
            this.setClockControlPanel(null);
            this.setLogoPanelVisible(false);
            this.setControlPanel(null);
            this.setHelpPanel(null);
        }

        public boolean hasHelp() {
            return true;
        }

        public void setHelpEnabled(boolean bl) {
            super.setHelpEnabled(bl);
            this.balloonsSimulationPanel.setHelpEnabled(bl);
        }

        public int getControlPanelHeight() {
            return this.balloonsSimulationPanel.getControlPanelHeight();
        }
    }
}

