/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.EquationTerm;
import java.awt.Dimension;

public class HorizontalAligner {
    private final Dimension boxSize;
    private final double boxSeparation;

    public HorizontalAligner(Dimension dimension, double d) {
        this.boxSize = new Dimension(dimension);
        this.boxSeparation = d;
    }

    public Dimension getBoxSizeReference() {
        return this.boxSize;
    }

    public double getBoxSeparation() {
        return this.boxSeparation;
    }

    public double getCenterXOffset() {
        return this.boxSize.getWidth() + this.boxSeparation / 2.0;
    }

    public double[] getReactantXOffsets(Equation equation) {
        return this.getXOffsets(equation.getReactants(), false, 0.0);
    }

    public double[] getProductXOffsets(Equation equation) {
        return this.getXOffsets(equation.getProducts(), true, this.boxSize.getWidth() + this.boxSeparation);
    }

    private double[] getXOffsets(EquationTerm[] equationTermArray, boolean bl, double d) {
        int n = equationTermArray.length;
        double[] dArray = new double[n];
        if (n == 1) {
            dArray[0] = bl ? d + 0.25 * this.boxSize.getWidth() : d + 0.75 * this.boxSize.getWidth();
        } else {
            double d2 = this.boxSize.getWidth() / (double)n;
            double d3 = d + d2 / 2.0;
            for (int i = 0; i < n; ++i) {
                dArray[i] = d3;
                d3 += d2;
            }
        }
        return dArray;
    }
}

