/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.model.AtomCount;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.view.BalanceScaleNode;
import edu.colorado.phet.balancingchemicalequations.view.HorizontalAligner;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalanceScalesNode
extends PComposite {
    private final SimpleObserver coefficientsObserver;
    private final HorizontalAligner aligner;
    private Equation equation;

    public BalanceScalesNode(final Property<Equation> property, HorizontalAligner horizontalAligner) {
        this.aligner = horizontalAligner;
        this.coefficientsObserver = new SimpleObserver(){

            public void update() {
                BalanceScalesNode.this.updateNode();
            }
        };
        this.equation = property.get();
        property.addObserver(new SimpleObserver(){

            public void update() {
                BalanceScalesNode.this.equation.removeCoefficientsObserver(BalanceScalesNode.this.coefficientsObserver);
                BalanceScalesNode.this.equation = (Equation)property.get();
                BalanceScalesNode.this.equation.addCoefficientsObserver(BalanceScalesNode.this.coefficientsObserver);
            }
        });
    }

    private void updateNode() {
        this.removeAllChildren();
        ArrayList<AtomCount> arrayList = this.equation.getAtomCounts();
        double d = BalanceScaleNode.getBeamLength() + 32.0;
        double d2 = this.aligner.getCenterXOffset() - (double)(arrayList.size() - 1) * BalanceScaleNode.getBeamLength() / 2.0 - (double)(arrayList.size() - 1) * 32.0 / 2.0;
        for (AtomCount atomCount : arrayList) {
            boolean bl = this.equation.isBalanced();
            BalanceScaleNode balanceScaleNode = new BalanceScaleNode(atomCount.getElement(), atomCount.getReactantsCount(), atomCount.getProductsCount(), bl);
            this.addChild(balanceScaleNode);
            balanceScaleNode.setOffset(d2, 0.0);
            d2 += d;
        }
    }
}

