/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.view;

import edu.colorado.phet.balancingchemicalequations.BCEConstants;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Color;
import java.awt.geom.Dimension2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BCECanvas
extends PhetPCanvas {
    private PNode rootNode;

    public BCECanvas(final Property<Color> property) {
        super(BCEConstants.CANVAS_RENDERING_SIZE);
        property.addObserver(new SimpleObserver(){

            public void update() {
                BCECanvas.this.setBackground((Color)property.get());
            }
        });
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
    }

    protected void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    protected void centerRootNode() {
        this.centerNode(this.rootNode);
    }

    protected void centerNode(PNode pNode) {
        if (pNode != null) {
            Dimension2D dimension2D = this.getWorldSize();
            PBounds pBounds = pNode.getFullBoundsReference();
            double d = (dimension2D.getWidth() - pBounds.getWidth() - PNodeLayoutUtils.getOriginXOffset(pNode)) / 2.0;
            double d2 = (dimension2D.getHeight() - pBounds.getHeight() - PNodeLayoutUtils.getOriginYOffset(pNode)) / 2.0;
            pNode.setOffset(d, d2);
        }
    }

    @Override
    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            this.centerRootNode();
        }
    }
}

