/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.module.introduction;

import edu.colorado.phet.balancingchemicalequations.model.DecompositionEquation;
import edu.colorado.phet.balancingchemicalequations.model.DisplacementEquation;
import edu.colorado.phet.balancingchemicalequations.model.Equation;
import edu.colorado.phet.balancingchemicalequations.model.SynthesisEquation;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntroductionModel {
    private static final IntegerRange COEFFICENTS_RANGE = new IntegerRange(0, 3);
    public final Property<Equation> currentEquation;
    private final ArrayList<Equation> equations = new ArrayList<Equation>(){
        {
            this.add(new SynthesisEquation.Synthesis_N2_3H2_2NH3());
            this.add(new DecompositionEquation.Decomposition_2H2O_2H2_O2());
            this.add(new DisplacementEquation.Displacement_CH4_2O2_CO2_2H2O());
        }
    };

    public IntroductionModel() {
        this.currentEquation = new Property<Equation>(this.equations.get(0));
    }

    public void reset() {
        for (Equation equation : this.equations) {
            equation.reset();
        }
        this.currentEquation.reset();
    }

    public IntegerRange getCoefficientsRange() {
        return COEFFICENTS_RANGE;
    }

    public ArrayList<Equation> getEquations() {
        return this.equations;
    }
}

