/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balancingchemicalequations.model;

import edu.colorado.phet.chemistry.model.Atom;
import edu.colorado.phet.chemistry.model.Element;
import edu.colorado.phet.chemistry.molecules.C2H2Node;
import edu.colorado.phet.chemistry.molecules.C2H4Node;
import edu.colorado.phet.chemistry.molecules.C2H5ClNode;
import edu.colorado.phet.chemistry.molecules.C2H5OHNode;
import edu.colorado.phet.chemistry.molecules.C2H6Node;
import edu.colorado.phet.chemistry.molecules.CH2ONode;
import edu.colorado.phet.chemistry.molecules.CH3OHNode;
import edu.colorado.phet.chemistry.molecules.CH4Node;
import edu.colorado.phet.chemistry.molecules.H2ONode;
import edu.colorado.phet.chemistry.molecules.H2SNode;
import edu.colorado.phet.chemistry.molecules.HClNode;
import edu.colorado.phet.chemistry.molecules.HFNode;
import edu.colorado.phet.chemistry.molecules.HorizontalMoleculeNode;
import edu.colorado.phet.chemistry.molecules.NH3Node;
import edu.colorado.phet.chemistry.molecules.NO2Node;
import edu.colorado.phet.chemistry.molecules.OF2Node;
import edu.colorado.phet.chemistry.molecules.P4Node;
import edu.colorado.phet.chemistry.molecules.PCl3Node;
import edu.colorado.phet.chemistry.molecules.PCl5Node;
import edu.colorado.phet.chemistry.molecules.PF3Node;
import edu.colorado.phet.chemistry.molecules.PH3Node;
import edu.colorado.phet.chemistry.molecules.SO2Node;
import edu.colorado.phet.chemistry.molecules.SO3Node;
import edu.colorado.phet.chemistry.utils.ChemUtils;
import edu.umd.cs.piccolo.PNode;
import java.awt.Image;

public abstract class Molecule {
    private final Image image;
    private final Atom[] atoms;
    private final String symbol;

    public Molecule(Image image, Element ... elementArray) {
        this.image = image;
        this.symbol = ChemUtils.createSymbol(elementArray);
        this.atoms = new Atom[elementArray.length];
        for (int i = 0; i < this.atoms.length; ++i) {
            this.atoms[i] = new Atom(elementArray[i]);
        }
    }

    protected Molecule(PNode pNode, Element ... elementArray) {
        this(pNode.toImage(), elementArray);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Image getImage() {
        return this.image;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public boolean isBig() {
        return this.atoms.length > 5;
    }

    public static class C2H2
    extends Molecule {
        public C2H2() {
            super(new C2H2Node(), Element.C, Element.C, Element.H, Element.H);
        }
    }

    public static class C2H4
    extends Molecule {
        public C2H4() {
            super(new C2H4Node(), Element.C, Element.C, Element.H, Element.H, Element.H, Element.H);
        }
    }

    public static class C2H5Cl
    extends Molecule {
        public C2H5Cl() {
            super(new C2H5ClNode(), Element.C, Element.C, Element.H, Element.H, Element.H, Element.H, Element.H, Element.Cl);
        }
    }

    public static class C2H5OH
    extends Molecule {
        public C2H5OH() {
            super(new C2H5OHNode(), Element.C, Element.C, Element.H, Element.H, Element.H, Element.H, Element.H, Element.O, Element.H);
        }
    }

    public static class C2H6
    extends Molecule {
        public C2H6() {
            super(new C2H6Node(), Element.C, Element.C, Element.H, Element.H, Element.H, Element.H, Element.H, Element.H);
        }
    }

    public static class CH2O
    extends Molecule {
        public CH2O() {
            super(new CH2ONode(), Element.C, Element.H, Element.H, Element.O);
        }
    }

    public static class CH3OH
    extends Molecule {
        public CH3OH() {
            super(new CH3OHNode(), Element.C, Element.H, Element.H, Element.H, Element.O, Element.H);
        }
    }

    public static class CH4
    extends Molecule {
        public CH4() {
            super(new CH4Node(), Element.C, Element.H, Element.H, Element.H, Element.H);
        }
    }

    public static class CMolecule
    extends Molecule {
        public CMolecule() {
            super(new HorizontalMoleculeNode.CNode(), Element.C);
        }
    }

    public static class CO
    extends Molecule {
        public CO() {
            super(new HorizontalMoleculeNode.CONode(), Element.C, Element.O);
        }
    }

    public static class CO2
    extends Molecule {
        public CO2() {
            super(new HorizontalMoleculeNode.CO2Node(), Element.C, Element.O, Element.O);
        }
    }

    public static class CS2
    extends Molecule {
        public CS2() {
            super(new HorizontalMoleculeNode.CS2Node(), Element.C, Element.S, Element.S);
        }
    }

    public static class Cl2
    extends Molecule {
        public Cl2() {
            super(new HorizontalMoleculeNode.Cl2Node(), Element.Cl, Element.Cl);
        }
    }

    public static class F2
    extends Molecule {
        public F2() {
            super(new HorizontalMoleculeNode.F2Node(), Element.F, Element.F);
        }
    }

    public static class H2
    extends Molecule {
        public H2() {
            super(new HorizontalMoleculeNode.H2Node(), Element.H, Element.H);
        }
    }

    public static class H2O
    extends Molecule {
        public H2O() {
            super(new H2ONode(), Element.H, Element.H, Element.O);
        }
    }

    public static class H2S
    extends Molecule {
        public H2S() {
            super(new H2SNode(), Element.H, Element.H, Element.S);
        }
    }

    public static class HCl
    extends Molecule {
        public HCl() {
            super(new HClNode(), Element.H, Element.Cl);
        }
    }

    public static class HF
    extends Molecule {
        public HF() {
            super(new HFNode(), Element.H, Element.F);
        }
    }

    public static class N2
    extends Molecule {
        public N2() {
            super(new HorizontalMoleculeNode.N2Node(), Element.N, Element.N);
        }
    }

    public static class N2O
    extends Molecule {
        public N2O() {
            super(new HorizontalMoleculeNode.N2ONode(), Element.N, Element.N, Element.O);
        }
    }

    public static class NH3
    extends Molecule {
        public NH3() {
            super(new NH3Node(), Element.N, Element.H, Element.H, Element.H);
        }
    }

    public static class NO
    extends Molecule {
        public NO() {
            super(new HorizontalMoleculeNode.NONode(), Element.N, Element.O);
        }
    }

    public static class NO2
    extends Molecule {
        public NO2() {
            super(new NO2Node(), Element.N, Element.O, Element.O);
        }
    }

    public static class O2
    extends Molecule {
        public O2() {
            super(new HorizontalMoleculeNode.O2Node(), Element.O, Element.O);
        }
    }

    public static class OF2
    extends Molecule {
        public OF2() {
            super(new OF2Node(), Element.O, Element.F, Element.F);
        }
    }

    public static class P4
    extends Molecule {
        public P4() {
            super(new P4Node(), Element.P, Element.P, Element.P, Element.P);
        }
    }

    public static class PCl3
    extends Molecule {
        public PCl3() {
            super(new PCl3Node(), Element.P, Element.Cl, Element.Cl, Element.Cl);
        }
    }

    public static class PCl5
    extends Molecule {
        public PCl5() {
            super(new PCl5Node(), Element.P, Element.Cl, Element.Cl, Element.Cl, Element.Cl, Element.Cl);
        }
    }

    public static class PF3
    extends Molecule {
        public PF3() {
            super(new PF3Node(), Element.P, Element.F, Element.F, Element.F);
        }
    }

    public static class PH3
    extends Molecule {
        public PH3() {
            super(new PH3Node(), Element.P, Element.H, Element.H, Element.H);
        }
    }

    public static class SMolecule
    extends Molecule {
        public SMolecule() {
            super(new HorizontalMoleculeNode.SNode(), Element.S);
        }
    }

    public static class SO2
    extends Molecule {
        public SO2() {
            super(new SO2Node(), Element.S, Element.O, Element.O);
        }
    }

    public static class SO3
    extends Molecule {
        public SO3() {
            super(new SO3Node(), Element.S, Element.O, Element.O, Element.O);
        }
    }
}

