/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.kit;

import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.kit.Kit;
import edu.colorado.phet.common.piccolophet.nodes.kit.KitControlNode;
import edu.colorado.phet.common.piccolophet.nodes.kit.ZeroOffsetNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolox.nodes.PClip;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitSelectionNode<T extends PNode>
extends PNode {
    private static final IUserComponent DEFAULT_USER_COMPONENT = new UserComponent(KitSelectionNode.class);
    public final Property<Integer> selectedKit;
    private PTransformActivity activity;
    protected final PNode kitLayer;
    protected final PhetPPath background;
    private final ArrayList<Kit<T>> kits;
    protected ZeroOffsetNode controlHolderNode;

    public KitSelectionNode(IUserComponent iUserComponent, Property<Integer> property, Kit<T> ... kitArray) {
        this(iUserComponent, property, new Option.None<PNode>(), kitArray);
    }

    public KitSelectionNode(IUserComponent iUserComponent, Property<Integer> property, Option<PNode> option, Kit<T> ... kitArray) {
        this.kits = new ArrayList<Kit<T>>(Arrays.asList(kitArray));
        this.selectedKit = property;
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        for (Kit<T> kit : kitArray) {
            arrayList.add(new ZeroOffsetNode((PNode)kit.content));
        }
        Rectangle2D rectangle2D = this.getBoundingRectangle(arrayList);
        ArrayList<PNode> arrayList2 = new ArrayList<PNode>();
        for (Kit<T> object2 : kitArray) {
            if (!object2.title.isSome()) continue;
            arrayList2.add(new ZeroOffsetNode(object2.title.get()));
        }
        Rectangle2D rectangle2D2 = this.getBoundingRectangle(arrayList2);
        double d = new KitControlNode(iUserComponent, this.getKitCount(), property, option, 13.0).getFullBounds().getWidth();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, Math.max(Math.max(rectangle2D.getWidth(), rectangle2D2.getWidth()), d), rectangle2D.getHeight() + rectangle2D2.getHeight(), 20.0, 20.0);
        this.background = new PhetPPath(double_, null, null, null);
        this.addChild(this.background);
        this.kitLayer = new PNode();
        double d2 = 0.0;
        double d3 = this.background.getFullBounds().getHeight() - rectangle2D2.getHeight();
        for (Kit<T> kit : kitArray) {
            ZeroOffsetNode d6 = new ZeroOffsetNode(kit.title.getOrElse(new PNode()));
            ZeroOffsetNode zeroOffsetNode = new ZeroOffsetNode((PNode)kit.content);
            d6.setOffset(d2 + this.background.getFullBounds().getWidth() / 2.0 - d6.getFullBounds().getWidth() / 2.0, 0.0);
            zeroOffsetNode.setOffset(d2 + this.background.getFullBounds().getWidth() / 2.0 - zeroOffsetNode.getFullBounds().getWidth() / 2.0, rectangle2D2.getHeight() + d3 / 2.0 - zeroOffsetNode.getFullBounds().getHeight() / 2.0);
            this.kitLayer.addChild(d6);
            this.kitLayer.addChild(zeroOffsetNode);
            d2 += this.background.getFullBounds().getWidth();
        }
        this.addChild(new PClip(){
            {
                this.setPathTo(KitSelectionNode.this.background.getPathReference());
                this.setStroke(null);
                this.addChild(KitSelectionNode.this.kitLayer);
            }
        });
        property.addObserver(new VoidFunction1<Integer>(){

            @Override
            public void apply(Integer n) {
                KitSelectionNode.this.scrollTo(n);
            }
        });
        double d4 = this.background.getFullBounds().getWidth();
        double d5 = d4 - d;
        double d6 = d5 / 2.0;
        this.controlHolderNode = new ZeroOffsetNode((PNode)new KitControlNode(iUserComponent, this.getKitCount(), property, option, d6 + 10.0)){
            {
                this.setOffset(KitSelectionNode.this.background.getFullBounds().getCenterX() - this.getFullBounds().getWidth() / 2.0, KitSelectionNode.this.background.getFullBounds().getMinY() - this.getFullBounds().getHeight());
            }
        };
        this.addChild(this.controlHolderNode);
    }

    private Rectangle2D getBoundingRectangle(ArrayList<PNode> arrayList) {
        if (arrayList.size() == 0) {
            return new Rectangle();
        }
        Rectangle2D rectangle2D = arrayList.get(0).getFullBounds();
        for (PNode pNode : arrayList) {
            rectangle2D = ((Rectangle2D)rectangle2D).createUnion(pNode.getFullBounds());
        }
        rectangle2D = RectangleUtils.expand(rectangle2D, 2.0, 2.0);
        return rectangle2D;
    }

    private void scrollTo(int n) {
        if (n >= 0 && n < this.kitLayer.getChildrenCount()) {
            if (this.activity != null) {
                this.activity.terminate(0);
            }
            this.selectedKit.set(n);
            double d = this.background.getFullBounds().getWidth() * (double)n;
            this.activity = this.kitLayer.animateToPositionScaleRotation(-d, 0.0, 1.0, 0.0, 500L);
        }
    }

    public int getKitCount() {
        return this.kits.size();
    }
}

