/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameModel;
import edu.colorado.phet.balanceandtorque.game.model.TiltPrediction;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiltPredictionSelectorNode
extends PNode {
    public Property<TiltPrediction> tiltPredictionProperty = new Property<TiltPrediction>(TiltPrediction.NONE);

    public TiltPredictionSelectorNode(Property<BalanceGameModel.GameState> property) {
        HBox hBox = new HBox(new TiltPredictionSelectionPanel(BalanceAndTorqueSimSharing.UserComponents.tiltLeftButton, BalanceAndTorqueResources.Images.PLANK_TIPPED_LEFT, TiltPrediction.TILT_DOWN_ON_LEFT_SIDE, this.tiltPredictionProperty, property), new TiltPredictionSelectionPanel(BalanceAndTorqueSimSharing.UserComponents.stayBalancedButton, BalanceAndTorqueResources.Images.PLANK_BALANCED, TiltPrediction.STAY_BALANCED, this.tiltPredictionProperty, property), new TiltPredictionSelectionPanel(BalanceAndTorqueSimSharing.UserComponents.tiltRightButton, BalanceAndTorqueResources.Images.PLANK_TIPPED_RIGHT, TiltPrediction.TILT_DOWN_ON_RIGHT_SIDE, this.tiltPredictionProperty, property));
        this.addChild(new ControlPanelNode((PNode)hBox));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TiltPredictionSelectionPanel
    extends PNode {
        private static final Color NON_HIGHLIGHT_COLOR = Color.BLACK;
        private static final Stroke NON_HIGHLIGHT_STROKE = new BasicStroke(1.0f);
        private static final Color SELECTED_HIGHLIGHT_COLOR = new Color(255, 215, 0);
        private static final Stroke SELECTED_HIGHLIGHT_STROKE = new BasicStroke(6.0f);
        private static final Color CORRECT_ANSWER_HIGHLIGHT_COLOR = new Color(0, 255, 0);
        private static final Stroke CORRECT_ANSWER_HIGHLIGHT_STROKE = new BasicStroke(6.0f);
        protected PPath outline;

        private TiltPredictionSelectionPanel(final IUserComponent iUserComponent, Image image, final TiltPrediction tiltPrediction, final Property<TiltPrediction> property, final Property<BalanceGameModel.GameState> property2) {
            PImage pImage = new PImage(image);
            pImage.setScale(220.0 / pImage.getFullBoundsReference().width);
            this.addChild(pImage);
            pImage.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseReleased(PInputEvent pInputEvent) {
                    property.set(tiltPrediction);
                    SimSharingManager.sendUserMessage(iUserComponent, UserComponentTypes.radioButton, UserActions.pressed);
                }
            });
            this.outline = new PhetPPath(pImage.getFullBoundsReference().getBounds2D(), NON_HIGHLIGHT_STROKE, (Paint)NON_HIGHLIGHT_COLOR);
            this.addChild(this.outline);
            property.addObserver(new VoidFunction1<TiltPrediction>(){

                @Override
                public void apply(TiltPrediction tiltPrediction2) {
                    TiltPredictionSelectionPanel.this.updateHighlightState(tiltPrediction2 == tiltPrediction, property2.get() == BalanceGameModel.GameState.DISPLAYING_CORRECT_ANSWER);
                }
            });
            property2.addObserver(new VoidFunction1<BalanceGameModel.GameState>(){

                @Override
                public void apply(BalanceGameModel.GameState gameState) {
                    TiltPredictionSelectionPanel.this.updateHighlightState(property.get() == tiltPrediction, gameState == BalanceGameModel.GameState.DISPLAYING_CORRECT_ANSWER);
                }
            });
            pImage.addInputEventListener(new CursorHandler(CursorHandler.HAND));
        }

        private void updateHighlightState(boolean bl, boolean bl2) {
            Color color = NON_HIGHLIGHT_COLOR;
            Stroke stroke = NON_HIGHLIGHT_STROKE;
            if (bl) {
                if (bl2) {
                    color = CORRECT_ANSWER_HIGHLIGHT_COLOR;
                    stroke = CORRECT_ANSWER_HIGHLIGHT_STROKE;
                } else {
                    color = SELECTED_HIGHLIGHT_COLOR;
                    stroke = SELECTED_HIGHLIGHT_STROKE;
                }
            }
            this.outline.setStrokePaint(color);
            this.outline.setStroke(stroke);
        }
    }
}

