/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameModel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ControlPanelNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.HBox;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MassValueEntryNode
extends PNode {
    private static final Font TEXT_FONT = new PhetFont(18);
    private static final Color BACKGROUND_COLOR = new Color(234, 234, 174);
    private final JFormattedTextField numberEntryField;
    private final BalanceGameModel model;
    private TextButtonNode checkAnswerButton;
    private final PCanvas canvas;

    public MassValueEntryNode(BalanceGameModel balanceGameModel, PCanvas pCanvas) {
        this.model = balanceGameModel;
        this.canvas = pCanvas;
        PText pText = new PText(BalanceAndTorqueResources.Strings.MASS_EQUALS);
        pText.setFont(TEXT_FONT);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(BACKGROUND_COLOR);
        this.numberEntryField = new JFormattedTextField(NumberFormat.getNumberInstance());
        this.numberEntryField.setColumns(4);
        this.numberEntryField.setFont(TEXT_FONT);
        this.numberEntryField.setBorder(BorderFactory.createEtchedBorder());
        this.numberEntryField.requestFocus();
        jPanel.add(this.numberEntryField);
        PText pText2 = new PText(BalanceAndTorqueResources.Strings.KG);
        pText2.setFont(TEXT_FONT);
        this.numberEntryField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassValueEntryNode.this.submitProposedAnswer();
            }
        });
        PSwing pSwing = new PSwing(jPanel);
        this.checkAnswerButton = new TextButtonNode(BalanceAndTorqueResources.Strings.CHECK_ANSWER, new PhetFont(20), Color.YELLOW);
        this.checkAnswerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MassValueEntryNode.this.submitProposedAnswer();
            }
        });
        this.addChild(new ControlPanelNode((PNode)new VBox(10.0, new HBox(5.0, pText, pSwing, pText2), this.checkAnswerButton), BACKGROUND_COLOR));
    }

    public void clear() {
        this.numberEntryField.setText("");
    }

    private void submitProposedAnswer() {
        double d = this.numberEntryField.getValue() != null ? ((Number)this.numberEntryField.getValue()).doubleValue() : Double.NaN;
        this.model.checkAnswer(d);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MassValueEntryNode.this.canvas.requestFocusInWindow();
            }
        });
    }

    public static class DisplayAnswerNode
    extends PNode {
        private static final NumberFormat FORMATTER = new DecimalFormat("##.#");
        private final MassValueEntryNode massValueEntryNode;

        public DisplayAnswerNode(BalanceGameModel balanceGameModel, PCanvas pCanvas) {
            this.massValueEntryNode = new MassValueEntryNode(balanceGameModel, pCanvas);
            this.addChild(this.massValueEntryNode);
            this.massValueEntryNode.checkAnswerButton.setVisible(false);
            this.massValueEntryNode.numberEntryField.setEnabled(false);
            this.update();
        }

        public void update() {
            BalanceGameChallenge balanceGameChallenge = this.massValueEntryNode.model.getCurrentChallenge();
            if (balanceGameChallenge != null) {
                this.massValueEntryNode.numberEntryField.setText(FORMATTER.format(balanceGameChallenge.getFixedMassValueTotal()));
            } else {
                this.massValueEntryNode.numberEntryField.setText("");
            }
        }
    }
}

