/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.balanceandtorque.game.view;

import edu.colorado.phet.balanceandtorque.BalanceAndTorqueResources;
import edu.colorado.phet.balanceandtorque.BalanceAndTorqueSimSharing;
import edu.colorado.phet.balanceandtorque.balancelab.view.AttachmentBarNode;
import edu.colorado.phet.balanceandtorque.common.model.ColumnState;
import edu.colorado.phet.balanceandtorque.common.model.LevelSupportColumn;
import edu.colorado.phet.balanceandtorque.common.model.ShapeModelElement;
import edu.colorado.phet.balanceandtorque.common.model.masses.Mass;
import edu.colorado.phet.balanceandtorque.common.view.FulcrumAbovePlankNode;
import edu.colorado.phet.balanceandtorque.common.view.LevelIndicatorNode;
import edu.colorado.phet.balanceandtorque.common.view.LevelSupportColumnNode;
import edu.colorado.phet.balanceandtorque.common.view.MassNodeFactory;
import edu.colorado.phet.balanceandtorque.common.view.PlankNode;
import edu.colorado.phet.balanceandtorque.common.view.RotatingRulerNode;
import edu.colorado.phet.balanceandtorque.common.view.TiltedSupportColumnNode;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameChallenge;
import edu.colorado.phet.balanceandtorque.game.model.BalanceGameModel;
import edu.colorado.phet.balanceandtorque.game.model.BalanceMassesChallenge;
import edu.colorado.phet.balanceandtorque.game.model.MassDistancePair;
import edu.colorado.phet.balanceandtorque.game.model.TiltPrediction;
import edu.colorado.phet.balanceandtorque.game.model.TiltPredictionChallenge;
import edu.colorado.phet.balanceandtorque.game.view.MassValueEntryNode;
import edu.colorado.phet.balanceandtorque.game.view.TiltPredictionSelectorNode;
import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.games.GameOverNode;
import edu.colorado.phet.common.games.GameScoreboardNode;
import edu.colorado.phet.common.games.GameSettingsPanel;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.OutlineTextNode;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.background.OutsideBackgroundNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;

public class BalanceGameCanvas
extends PhetPCanvas {
    private static final double FACE_DIAMETER = PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() * 0.3;
    private static final Color FACE_COLOR = new Color(255, 255, 0, 180);
    private static final Color EYE_AND_MOUTH_COLOR = new Color(0, 0, 0, 100);
    private static Font BUTTON_FONT = new PhetFont(24, false);
    private static final GameAudioPlayer GAME_AUDIO_PLAYER = new GameAudioPlayer(true){
        {
            this.init();
        }
    };
    public static final Color ACTIVE_BUTTON_COLOR = Color.YELLOW;
    private final BalanceGameModel model;
    private final GameScoreboardNode scoreboard;
    private PNode rootNode;
    private final PNode challengeLayer = new PNode();
    private final PNode controlLayer = new PNode();
    private PNode gameSettingsNode;
    private PNode gameOverNode = null;
    private final MassValueEntryNode massValueEntryNode;
    private final MassValueEntryNode.DisplayAnswerNode massValueAnswerNode;
    protected TiltPredictionSelectorNode tiltPredictionSelectorNode;
    private final SmileFaceWithScoreNode smilingFace = new SmileFaceWithScoreNode();
    private final PNode frowningFace = new FaceNode(FACE_DIAMETER, FACE_COLOR, EYE_AND_MOUTH_COLOR, EYE_AND_MOUTH_COLOR){
        {
            this.frown();
        }
    };
    private TextButtonNode checkAnswerButton = new TextButtonNode(BalanceAndTorqueResources.Strings.CHECK_ANSWER, BUTTON_FONT, ACTIVE_BUTTON_COLOR){
        {
            this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.checkAnswer);
        }
    };
    private TextButtonNode tryAgainButton = new TextButtonNode(BalanceAndTorqueResources.Strings.TRY_AGAIN, BUTTON_FONT, ACTIVE_BUTTON_COLOR){
        {
            this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.tryAgain);
        }
    };
    private TextButtonNode nextChallengeButton = new TextButtonNode(BalanceAndTorqueResources.Strings.NEXT, BUTTON_FONT, ACTIVE_BUTTON_COLOR){
        {
            this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.nextChallenge);
        }
    };
    private TextButtonNode displayCorrectAnswerButton = new TextButtonNode(BalanceAndTorqueResources.Strings.DISPLAY_CORRECT_ANSWER, BUTTON_FONT, ACTIVE_BUTTON_COLOR){
        {
            this.setUserComponent(BalanceAndTorqueSimSharing.UserComponents.displayAnswer);
        }
    };
    private OutlineTextNode challengeTitleNode;
    private ModelViewTransform mvt;

    public BalanceGameCanvas(final BalanceGameModel balanceGameModel) {
        this.model = balanceGameModel;
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this));
        this.mvt = ModelViewTransform.createSinglePointScaleInvertedYMapping(new Point2D.Double(0.0, 0.0), new Point((int)Math.round(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() * 0.4), (int)Math.round(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() * 0.75)), 150.0);
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
        this.rootNode.addChild(new OutsideBackgroundNode(this.mvt, 3.0, 1.0));
        this.rootNode.addChild(this.controlLayer);
        this.rootNode.addChild(this.challengeLayer);
        this.challengeLayer.addChild(new FulcrumAbovePlankNode(this.mvt, balanceGameModel.getFulcrum()));
        this.challengeLayer.addChild(new TiltedSupportColumnNode(this.mvt, (ShapeModelElement)balanceGameModel.getTiltSupportColumn(), balanceGameModel.supportColumnState));
        for (LevelSupportColumn object2 : balanceGameModel.getLevelSupportColumns()) {
            this.challengeLayer.addChild(new LevelSupportColumnNode(this.mvt, object2, balanceGameModel.supportColumnState, false));
        }
        this.challengeLayer.addChild(new PlankNode(this.mvt, balanceGameModel.getPlank(), this){
            {
                this.setPickable(false);
                this.setChildrenPickable(false);
            }
        });
        this.challengeLayer.addChild(new AttachmentBarNode(this.mvt, balanceGameModel.getAttachmentBar()));
        balanceGameModel.movableMasses.addElementAddedObserver(new VoidFunction1<Mass>(){

            @Override
            public void apply(Mass mass) {
                final PNode pNode = BalanceGameCanvas.this.createMassNode(mass);
                BalanceGameCanvas.this.challengeLayer.addChild(pNode);
                balanceGameModel.movableMasses.addElementRemovedObserver(mass, new VoidFunction0(){

                    public void apply() {
                        BalanceGameCanvas.this.challengeLayer.removeChild(pNode);
                    }
                });
            }
        });
        balanceGameModel.fixedMasses.addElementAddedObserver(new VoidFunction1<MassDistancePair>(){

            @Override
            public void apply(MassDistancePair massDistancePair) {
                final PNode pNode = BalanceGameCanvas.this.createMassNode(massDistancePair.mass);
                pNode.setPickable(false);
                pNode.setChildrenPickable(false);
                BalanceGameCanvas.this.challengeLayer.addChild(pNode);
                balanceGameModel.fixedMasses.addElementRemovedObserver(massDistancePair, new VoidFunction0(){

                    public void apply() {
                        BalanceGameCanvas.this.challengeLayer.removeChild(pNode);
                    }
                });
            }
        });
        VoidFunction0 voidFunction0 = new VoidFunction0(){

            public void apply() {
                balanceGameModel.startGame();
            }
        };
        this.gameSettingsNode = new PSwing(new GameSettingsPanel(balanceGameModel.gameSettings, voidFunction0, Color.YELLOW)){
            {
                this.scale(1.5);
                this.setOffset(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() / 2.0 - this.getFullBoundsReference().width / 2.0, PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() / 2.0 - this.getFullBoundsReference().height / 2.0);
            }
        };
        this.rootNode.addChild(this.gameSettingsNode);
        balanceGameModel.gameSettings.soundEnabled.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                GAME_AUDIO_PLAYER.setEnabled(bl);
            }
        });
        this.scoreboard = new GameScoreboardNode(4, balanceGameModel.getMaximumPossibleScore(), new DecimalFormat("0.#")){
            {
                super(n, d, numberFormat);
                this.setBackgroundWidth(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() * 0.85);
                balanceGameModel.getClock().addClockListener(new ClockAdapter(){

                    public void simulationTimeChanged(ClockEvent clockEvent) {
                        if (balanceGameModel.isTimerEnabled() && balanceGameModel.isBestTimeRecorded(balanceGameModel.getLevel())) {
                            this.setTime(BalanceGameCanvas.convertSecondsToMilliseconds(balanceGameModel.getElapsedTime()), BalanceGameCanvas.convertSecondsToMilliseconds(balanceGameModel.getBestTime(balanceGameModel.getLevel())));
                        } else {
                            this.setTime(BalanceGameCanvas.convertSecondsToMilliseconds(balanceGameModel.getElapsedTime()));
                        }
                    }
                });
                balanceGameModel.getScoreProperty().addObserver(new SimpleObserver(){

                    public void update() {
                        this.setScore(balanceGameModel.getScoreProperty().get().intValue());
                    }
                });
                balanceGameModel.getGameSettings().timerEnabled.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setTimerVisible((Boolean)balanceGameModel.getGameSettings().timerEnabled.get());
                    }
                });
                balanceGameModel.getGameSettings().level.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setLevel((Integer)balanceGameModel.getGameSettings().level.get());
                    }
                });
            }
        };
        this.scoreboard.addGameScoreboardListener(new GameScoreboardNode.GameScoreboardListener(){

            public void newGamePressed() {
                balanceGameModel.showGameInitDialog();
            }
        });
        this.scoreboard.setOffset(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() / 2.0 - this.scoreboard.getFullBoundsReference().width / 2.0, PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() - this.scoreboard.getFullBoundsReference().height - 20.0);
        this.rootNode.addChild(this.scoreboard);
        this.challengeTitleNode = new OutlineTextNode("Blank", new PhetFont(64, true), Color.WHITE, Color.BLACK, 1.0);
        this.updateTitle();
        this.rootNode.addChild(this.challengeTitleNode);
        this.massValueEntryNode = new MassValueEntryNode(balanceGameModel, this);
        this.rootNode.addChild(this.massValueEntryNode);
        this.massValueAnswerNode = new MassValueEntryNode.DisplayAnswerNode(balanceGameModel, this);
        this.rootNode.addChild(this.massValueAnswerNode);
        Point2D.Double double_ = new Point2D.Double(this.mvt.modelToViewX(0.0), this.challengeTitleNode.getFullBoundsReference().getMaxY() + this.massValueEntryNode.getFullBounds().height / 2.0 + 10.0);
        this.massValueEntryNode.centerFullBoundsOnPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
        this.massValueAnswerNode.centerFullBoundsOnPoint(((Point2D)double_).getX(), ((Point2D)double_).getY());
        this.tiltPredictionSelectorNode = new TiltPredictionSelectorNode(balanceGameModel.gameStateProperty);
        this.rootNode.addChild(this.tiltPredictionSelectorNode);
        Point2D.Double double_2 = new Point2D.Double(this.mvt.modelToViewX(0.0), this.challengeTitleNode.getFullBoundsReference().getMaxY() + 100.0);
        this.tiltPredictionSelectorNode.centerFullBoundsOnPoint(((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        Point2D.Double double_3 = new Point2D.Double(this.mvt.modelToViewX(0.0), FACE_DIAMETER / 2.0 + 20.0);
        this.smilingFace.centerFullBoundsOnPoint(((Point2D)double_3).getX(), ((Point2D)double_3).getY());
        this.frowningFace.centerFullBoundsOnPoint(((Point2D)double_3).getX(), ((Point2D)double_3).getY());
        this.rootNode.addChild(this.smilingFace);
        this.rootNode.addChild(this.frowningFace);
        this.checkAnswerButton.centerFullBoundsOnPoint(this.mvt.modelToViewX(0.0), this.mvt.modelToViewY(0.0) + 40.0);
        this.checkAnswerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (balanceGameModel.getCurrentChallenge() instanceof BalanceMassesChallenge) {
                    balanceGameModel.checkAnswer();
                } else if (balanceGameModel.getCurrentChallenge() instanceof TiltPredictionChallenge) {
                    balanceGameModel.checkAnswer(BalanceGameCanvas.this.tiltPredictionSelectorNode.tiltPredictionProperty.get());
                } else {
                    System.out.println(this.getClass().getName() + " Error: No check answer handler exists for this challenge type.");
                    assert (false);
                }
            }
        });
        this.rootNode.addChild(this.checkAnswerButton);
        this.tryAgainButton.centerFullBoundsOnPoint(this.mvt.modelToViewX(0.0), this.mvt.modelToViewY(0.0) + 40.0);
        this.tryAgainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                balanceGameModel.tryAgain();
            }
        });
        this.rootNode.addChild(this.tryAgainButton);
        this.nextChallengeButton.centerFullBoundsOnPoint(this.mvt.modelToViewX(0.0), this.mvt.modelToViewY(0.0) + 40.0);
        this.nextChallengeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                balanceGameModel.nextChallenge();
            }
        });
        this.rootNode.addChild(this.nextChallengeButton);
        this.displayCorrectAnswerButton.centerFullBoundsOnPoint(this.mvt.modelToViewX(0.0), this.mvt.modelToViewY(0.0) + 40.0);
        this.displayCorrectAnswerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                balanceGameModel.displayCorrectAnswer();
            }
        });
        this.rootNode.addChild(this.displayCorrectAnswerButton);
        VoidFunction1<Mass> voidFunction1 = new VoidFunction1<Mass>(){

            @Override
            public void apply(Mass mass) {
                BalanceGameCanvas.this.updateCheckAnswerButtonEnabled();
            }
        };
        balanceGameModel.getPlank().massesOnSurface.addElementAddedObserver(voidFunction1);
        balanceGameModel.getPlank().massesOnSurface.addElementRemovedObserver(voidFunction1);
        this.tiltPredictionSelectorNode.tiltPredictionProperty.addObserver(new SimpleObserver(){

            public void update() {
                BalanceGameCanvas.this.updateCheckAnswerButtonEnabled();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                if (keyEvent.getKeyChar() == '\n') {
                    if (BalanceGameCanvas.this.nextChallengeButton.isVisible() && BalanceGameCanvas.this.nextChallengeButton.isEnabled()) {
                        balanceGameModel.nextChallenge();
                    } else if (BalanceGameCanvas.this.tryAgainButton.isVisible() && BalanceGameCanvas.this.tryAgainButton.isEnabled()) {
                        balanceGameModel.tryAgain();
                    } else if (BalanceGameCanvas.this.checkAnswerButton.isVisible() && BalanceGameCanvas.this.checkAnswerButton.isEnabled()) {
                        balanceGameModel.checkAnswer();
                    } else if (BalanceGameCanvas.this.displayCorrectAnswerButton.isVisible() && BalanceGameCanvas.this.displayCorrectAnswerButton.isEnabled()) {
                        balanceGameModel.displayCorrectAnswer();
                    }
                }
            }
        });
        balanceGameModel.gameStateProperty.addObserver(new VoidFunction1<BalanceGameModel.GameState>(){

            @Override
            public void apply(BalanceGameModel.GameState gameState) {
                BalanceGameCanvas.this.handleGameStateChange(gameState);
            }
        });
        this.challengeLayer.addChild(new LevelIndicatorNode(this.mvt, balanceGameModel.getPlank()){
            {
                super(modelViewTransform, plank);
                balanceGameModel.supportColumnState.addObserver(new VoidFunction1<ColumnState>(){

                    @Override
                    public void apply(ColumnState columnState) {
                        this.setVisible(columnState == ColumnState.NONE);
                    }
                });
            }
        });
        BooleanProperty booleanProperty = new BooleanProperty(false);
        PropertyCheckBox propertyCheckBox = new PropertyCheckBox(BalanceAndTorqueSimSharing.UserComponents.rulersCheckBox, BalanceAndTorqueResources.Strings.SHOW_RULERS, booleanProperty);
        propertyCheckBox.setFont(new PhetFont(16));
        propertyCheckBox.setBackground(new Color(0, 0, 0, 0));
        this.controlLayer.addChild(new PSwing(propertyCheckBox){
            {
                this.setOffset(BalanceGameCanvas.this.mvt.modelToViewX(3.0) - this.getFullBoundsReference().width / 2.0, BalanceGameCanvas.this.mvt.modelToViewY(-0.25));
            }
        });
        this.challengeLayer.addChild(new RotatingRulerNode(balanceGameModel.getPlank(), this.mvt, booleanProperty));
    }

    private void setNodeVisibility(boolean bl, PNode ... pNodeArray) {
        for (PNode pNode : pNodeArray) {
            pNode.setVisible(bl);
        }
    }

    private void show(PNode ... pNodeArray) {
        this.setNodeVisibility(true, pNodeArray);
    }

    private void hideAllGameNodes() {
        this.setNodeVisibility(false, this.smilingFace, this.frowningFace, this.gameSettingsNode, this.scoreboard, this.challengeTitleNode, this.checkAnswerButton, this.tryAgainButton, this.nextChallengeButton, this.displayCorrectAnswerButton, this.massValueEntryNode, this.massValueAnswerNode, this.tiltPredictionSelectorNode);
    }

    private void handleGameStateChange(BalanceGameModel.GameState gameState) {
        this.hideAllGameNodes();
        if (gameState == BalanceGameModel.GameState.OBTAINING_GAME_SETUP) {
            this.show(this.gameSettingsNode);
            this.hideChallenge();
            if (this.gameOverNode != null) {
                this.rootNode.removeChild(this.gameOverNode);
                this.gameOverNode = null;
            }
        } else if (gameState == BalanceGameModel.GameState.PRESENTING_INTERACTIVE_CHALLENGE) {
            this.updateTitle();
            this.show(this.scoreboard, this.challengeTitleNode);
            if (this.model.getCurrentChallenge().getChallengeViewConfig().showMassEntryDialog) {
                this.massValueEntryNode.clear();
                this.show(this.massValueEntryNode);
            } else {
                this.show(this.checkAnswerButton);
                if (this.model.getCurrentChallenge().getChallengeViewConfig().showTiltPredictionSelector) {
                    this.tiltPredictionSelectorNode.tiltPredictionProperty.reset();
                    this.show(this.tiltPredictionSelectorNode);
                }
            }
            this.showChallengeGraphics();
            this.challengeLayer.setPickable(true);
            this.challengeLayer.setChildrenPickable(true);
        } else if (gameState == BalanceGameModel.GameState.SHOWING_CORRECT_ANSWER_FEEDBACK) {
            GAME_AUDIO_PLAYER.correctAnswer();
            this.smilingFace.setScore(this.model.getChallengeCurrentPointValue());
            this.show(this.scoreboard, this.nextChallengeButton, this.smilingFace);
            this.showChallengeGraphics();
        } else if (gameState == BalanceGameModel.GameState.SHOWING_INCORRECT_ANSWER_FEEDBACK_TRY_AGAIN) {
            GAME_AUDIO_PLAYER.wrongAnswer();
            this.show(this.scoreboard, this.tryAgainButton, this.frowningFace);
            this.showChallengeGraphics();
        } else if (gameState == BalanceGameModel.GameState.SHOWING_INCORRECT_ANSWER_FEEDBACK_MOVE_ON) {
            GAME_AUDIO_PLAYER.wrongAnswer();
            this.show(this.scoreboard, this.displayCorrectAnswerButton, this.frowningFace);
            this.showChallengeGraphics();
        } else if (gameState == BalanceGameModel.GameState.DISPLAYING_CORRECT_ANSWER) {
            this.show(this.scoreboard, this.nextChallengeButton);
            if (this.model.getCurrentChallenge().getChallengeViewConfig().showMassEntryDialog) {
                this.massValueAnswerNode.update();
                this.show(this.massValueAnswerNode);
            } else if (this.model.getCurrentChallenge().getChallengeViewConfig().showTiltPredictionSelector) {
                this.tiltPredictionSelectorNode.tiltPredictionProperty.set(this.model.getTipDirection());
                this.show(this.tiltPredictionSelectorNode);
            }
            this.showChallengeGraphics();
        } else if (gameState == BalanceGameModel.GameState.SHOWING_GAME_RESULTS) {
            if (this.model.getScoreProperty().get().intValue() == this.model.getMaximumPossibleScore()) {
                GAME_AUDIO_PLAYER.gameOverPerfectScore();
            } else if (this.model.getScoreProperty().get() == 0) {
                GAME_AUDIO_PLAYER.gameOverZeroScore();
            } else {
                GAME_AUDIO_PLAYER.gameOverImperfectScore();
            }
            this.showGameOverNode();
            this.hideChallenge();
        }
    }

    private void updateTitle() {
        BalanceGameChallenge balanceGameChallenge = this.model.getCurrentChallenge();
        if (balanceGameChallenge != null) {
            this.challengeTitleNode.setText(this.model.getCurrentChallenge().getChallengeViewConfig().title);
        } else {
            this.challengeTitleNode.setText("No challenge available.");
        }
        this.challengeTitleNode.setOffset(this.mvt.modelToViewX(0.0) - this.challengeTitleNode.getFullBoundsReference().width / 2.0, PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() * 0.15 - this.challengeTitleNode.getFullBoundsReference().height / 2.0);
    }

    private void updateCheckAnswerButtonEnabled() {
        if (this.model.getCurrentChallenge() instanceof BalanceMassesChallenge) {
            boolean bl = false;
            for (Mass mass : this.model.getPlank().massesOnSurface) {
                if (!(mass.getPosition().getX() > this.model.getPlank().getPlankSurfaceCenter().getX())) continue;
                bl = true;
                break;
            }
            this.checkAnswerButton.setEnabled(bl);
        } else if (this.model.getCurrentChallenge() instanceof TiltPredictionChallenge) {
            this.checkAnswerButton.setEnabled(this.tiltPredictionSelectorNode.tiltPredictionProperty.get() != TiltPrediction.NONE);
        }
    }

    private void hideChallenge() {
        this.challengeLayer.setVisible(false);
        this.controlLayer.setVisible(false);
    }

    private void showChallengeGraphics() {
        this.challengeLayer.setVisible(true);
        this.controlLayer.setVisible(true);
        this.challengeLayer.setPickable(false);
        this.challengeLayer.setChildrenPickable(false);
    }

    private void showGameOverNode() {
        assert (this.gameOverNode == null);
        this.gameOverNode = new GameOverNode(this.model.getLevel(), (double)this.model.getScoreProperty().get().intValue(), this.model.getMaximumPossibleScore(), new DecimalFormat("##"), BalanceGameCanvas.convertSecondsToMilliseconds(this.model.getElapsedTime()), BalanceGameCanvas.convertSecondsToMilliseconds(this.model.getBestTime(this.model.getLevel())), this.model.isNewBestTime(), (Boolean)this.model.gameSettings.timerEnabled.get()){
            {
                this.scale(1.5);
                this.setOffset(PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getWidth() / 2.0 - this.getFullBoundsReference().width / 2.0, PhetPCanvas.CenteredStage.DEFAULT_STAGE_SIZE.getHeight() / 2.0 - this.getFullBoundsReference().height / 2.0);
                this.addGameOverListener(new GameOverNode.GameOverListener(){

                    public void newGamePressed() {
                        BalanceGameCanvas.this.model.showGameInitDialog();
                    }
                });
            }
        };
        this.rootNode.addChild(this.gameOverNode);
    }

    private PNode createMassNode(Mass mass) {
        return MassNodeFactory.createMassNode(mass, new BooleanProperty(!mass.isMystery()), this.mvt, this);
    }

    static long convertSecondsToMilliseconds(double d) {
        return (long)(d * 1000.0);
    }

    static /* synthetic */ double access$1200() {
        return FACE_DIAMETER;
    }

    static /* synthetic */ Color access$1300() {
        return FACE_COLOR;
    }

    static /* synthetic */ Color access$1400() {
        return EYE_AND_MOUTH_COLOR;
    }

    private static class SmileFaceWithScoreNode
    extends PNode {
        private static final Font SCORE_FONT = new PhetFont(60, true);
        private OutlineTextNode scoreNode;
        private FaceNode faceNode = new FaceNode(BalanceGameCanvas.access$1200(), BalanceGameCanvas.access$1300(), BalanceGameCanvas.access$1400(), BalanceGameCanvas.access$1400());

        private SmileFaceWithScoreNode() {
            this.addChild(this.faceNode);
            this.scoreNode = new OutlineTextNode("X", SCORE_FONT, Color.YELLOW, Color.BLACK, 1.0);
            this.addChild(this.scoreNode);
        }

        public void setScore(int n) {
            if (n >= 0) {
                this.scoreNode.setText("+" + Integer.toString(n));
                this.scoreNode.setOffset(this.faceNode.getFullBoundsReference().getMaxX() - this.scoreNode.getFullBoundsReference().width + 10.0, this.faceNode.getFullBoundsReference().getMaxY() - this.scoreNode.getFullBoundsReference().height);
            } else {
                System.out.println(this.getClass().getName() + " - Warning: Attempt to set zero or negative score.");
                this.scoreNode.setText("");
            }
        }
    }
}

